/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.Queue;
import java.util.Set;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;

public class DeleteMarksCommand
extends CountIgnoringNonRepeatableCommand {
    private Queue<String> marks;

    public DeleteMarksCommand(Queue<String> marks) {
        this.marks = marks;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        CursorService cursor = editorAdaptor.getCursorService();
        if (this.marks.size() == 1 && "!".equals(this.marks.peek())) {
            Set<String> all = cursor.getAllMarks();
            for (String mark : all) {
                if (Character.isUpperCase(mark.charAt(0)) || Character.isDigit(mark.charAt(0)) || mark.equals("'")) continue;
                cursor.deleteMark(mark);
            }
            this.marks.poll();
        }
        while (this.marks.size() > 0) {
            String mark = this.marks.poll();
            if (mark.contains("-") && mark.length() == 3) {
                String[] bounds = mark.split("-");
                char start = bounds[0].charAt(0);
                char end = bounds[1].charAt(0);
                char i = start;
                while (i <= end) {
                    cursor.deleteMark("" + i);
                    i = (char)(i + '\u0001');
                }
                continue;
            }
            int i = 0;
            while (i < mark.length()) {
                cursor.deleteMark("" + mark.charAt(i));
                ++i;
            }
        }
    }
}

