/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineAddressParser;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractLinewiseOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class CopyMoveLinesOperation
extends AbstractLinewiseOperation {
    private String address = null;
    private boolean move;

    public CopyMoveLinesOperation(String op, boolean move) {
        assert (op.length() >= 1);
        int addrPos = 1;
        while (addrPos < op.length()) {
            char ch = op.charAt(addrPos);
            if (!Character.isLetter(ch) && !Character.isWhitespace(ch)) break;
            ++addrPos;
        }
        if (addrPos < op.length()) {
            this.address = op.substring(addrPos).trim();
        }
        this.move = move;
    }

    @Override
    public TextOperation repetition() {
        return this;
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.singleLine(editorAdaptor, currentPos);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange range) throws CommandExecutionException {
        if (this.address == null) {
            throw new CommandExecutionException("Address required");
        }
        Position destination = LineAddressParser.parseAddressPosition(this.address, editorAdaptor);
        if (destination == null) {
            throw new CommandExecutionException("Invalid address");
        }
        TextContent content = editorAdaptor.getModelContent();
        TextRange region = range.getRegion(editorAdaptor, 0);
        String lines = content.getText(region);
        LineInformation line = content.getLineInformationOfOffset(destination.getModelOffset());
        int offset = content.getLineInformation(line.getNumber() + 1).getBeginOffset();
        int sourceOffset = region.getStart().getModelOffset();
        LineInformation sourceLine = content.getLineInformationOfOffset(region.getLeftBound().getModelOffset());
        int cursorPos = offset + VimUtils.getFirstNonWhiteSpaceOffset(content, sourceLine) - sourceLine.getBeginOffset();
        editorAdaptor.getHistory().beginCompoundChange();
        if (this.move && offset < sourceOffset) {
            content.replace(sourceOffset, region.getModelLength(), "");
        }
        content.replace(offset, 0, lines);
        editorAdaptor.setPosition(editorAdaptor.getCursorService().newPositionForModelOffset(cursorPos), StickyColumnPolicy.ON_CHANGE);
        if (this.move && offset >= sourceOffset) {
            content.replace(sourceOffset, region.getModelLength(), "");
        }
        editorAdaptor.getHistory().endCompoundChange();
    }
}

