/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractTextObject;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextObject;

public class CommentTextObject
extends AbstractTextObject {
    public static final TextObject INNER = new CommentTextObject(false, false);
    public static final TextObject OUTER = new CommentTextObject(true, false);
    public static final TextObject INNER_LINE = new CommentTextObject(false, true);
    public static final TextObject OUTER_LINE = new CommentTextObject(true, true);
    private final Pattern singleLine = Pattern.compile("^\\s*((/(/)+|(#)+|-(-)+|(;)+)\\s*)");
    private final Pattern blockStart = Pattern.compile("\\s*((/(\\*)+|\\{(-)+|<!-(-)+)\\s*)");
    private final Pattern blockEnd = Pattern.compile("(\\s*((\\*)+/|(-)+\\}|(-)+->))");
    private final boolean outer;
    private final boolean linewise;

    private CommentTextObject(boolean outer, boolean linewise) {
        this.outer = outer;
        this.linewise = linewise;
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        TextContent model = editorAdaptor.getModelContent();
        CursorService cursorService = editorAdaptor.getCursorService();
        LineInformation line = model.getLineInformationOfOffset(editorAdaptor.getPosition().getModelOffset());
        String lineText = model.getText(line.getBeginOffset(), line.getLength());
        Matcher singleLineMatcher = this.singleLine.matcher(lineText);
        if (singleLineMatcher.find()) {
            int offset = this.outer ? singleLineMatcher.start(1) : singleLineMatcher.end(1);
            int start = line.getBeginOffset() + offset;
            if (this.linewise) {
                return this.getSingleLineComments(this.outer, start, editorAdaptor);
            }
            return new StartEndTextRange(cursorService.newPositionForModelOffset(start), cursorService.newPositionForModelOffset(line.getEndOffset()));
        }
        return this.getBlockComment(this.outer, editorAdaptor.getPosition().getModelOffset(), editorAdaptor);
    }

    private StartEndTextRange getSingleLineComments(boolean outer, int offset, EditorAdaptor editorAdaptor) {
        LineInformation lineOrig;
        TextContent model = editorAdaptor.getModelContent();
        CursorService cursorService = editorAdaptor.getCursorService();
        LineInformation line = lineOrig = model.getLineInformationOfOffset(offset);
        int start = offset;
        int end = line.getEndOffset();
        while (line.getNumber() > 0) {
            String lineText = model.getText((line = model.getLineInformation(line.getNumber() - 1)).getBeginOffset(), line.getLength());
            Matcher matcher = this.singleLine.matcher(lineText);
            if (!matcher.find()) break;
            offset = outer ? matcher.start(1) : matcher.end(1);
            start = line.getBeginOffset() + offset;
        }
        line = lineOrig;
        int totalLines = model.getNumberOfLines();
        while (line.getNumber() < totalLines) {
            String lineText = model.getText((line = model.getLineInformation(line.getNumber() + 1)).getBeginOffset(), line.getLength());
            Matcher matcher = this.singleLine.matcher(lineText);
            if (!matcher.find()) break;
            end = line.getEndOffset();
        }
        return new StartEndTextRange(cursorService.newPositionForModelOffset(start), cursorService.newPositionForModelOffset(end));
    }

    private StartEndTextRange getBlockComment(boolean linewise, int cursor, EditorAdaptor editorAdaptor) {
        int lineStart;
        Matcher matcher;
        int end;
        int start;
        CursorService cursorService;
        block8: {
            LineInformation line;
            LineInformation lineOrig;
            TextContent model;
            block7: {
                model = editorAdaptor.getModelContent();
                cursorService = editorAdaptor.getCursorService();
                line = lineOrig = model.getLineInformationOfOffset(cursor);
                start = cursor;
                end = cursor;
                while (true) {
                    int lineStart2;
                    String lineText;
                    Matcher matcher2;
                    if ((matcher2 = this.blockStart.matcher(lineText = model.getText(lineStart2 = line.getBeginOffset(), line.getLength()))).find()) {
                        int offset;
                        int n = offset = this.outer ? matcher2.start(1) : matcher2.end(1);
                        if (offset == line.getLength()) {
                            line = model.getLineInformation(line.getNumber() + 1);
                            start = line.getBeginOffset();
                        } else {
                            start = lineStart2 + offset;
                        }
                        break block7;
                    }
                    matcher2 = this.blockEnd.matcher(lineText);
                    if (matcher2.find() && lineStart2 + matcher2.end(1) < cursor) {
                        return new StartEndTextRange(cursorService.newPositionForModelOffset(cursor), cursorService.newPositionForModelOffset(cursor));
                    }
                    if (line.getNumber() <= 0) break;
                    line = model.getLineInformation(line.getNumber() - 1);
                }
                return new StartEndTextRange(cursorService.newPositionForModelOffset(cursor), cursorService.newPositionForModelOffset(cursor));
            }
            line = lineOrig;
            int totalLines = model.getNumberOfLines();
            while (true) {
                String lineText;
                if ((matcher = this.blockEnd.matcher(lineText = model.getText(lineStart = line.getBeginOffset(), line.getLength()))).find()) break block8;
                matcher = this.blockStart.matcher(lineText);
                if (matcher.find() && lineStart + matcher.start(1) > start) {
                    return new StartEndTextRange(cursorService.newPositionForModelOffset(cursor), cursorService.newPositionForModelOffset(cursor));
                }
                if (line.getNumber() >= totalLines) break;
                line = model.getLineInformation(line.getNumber() + 1);
            }
            return new StartEndTextRange(cursorService.newPositionForModelOffset(cursor), cursorService.newPositionForModelOffset(cursor));
        }
        int offset = this.outer ? matcher.end(1) : matcher.start(1);
        end = lineStart + offset;
        return new StartEndTextRange(cursorService.newPositionForModelOffset(start), cursorService.newPositionForModelOffset(end));
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return this.outer && this.linewise ? ContentType.LINES : ContentType.TEXT;
    }
}

