/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.MultipleExecutionCommand;
import net.sourceforge.vrapper.vim.commands.VimCommandSequence;
import net.sourceforge.vrapper.vim.commands.motions.Motion;

public class CommandWrappers {
    public static Command seq(Command ... commands) {
        return new VimCommandSequence(commands);
    }

    public static Command dontRepeat(final Command wrapped) {
        return new AbstractCommand(){

            @Override
            public CountAwareCommand repetition() {
                return null;
            }

            @Override
            public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
                wrapped.execute(editorAdaptor);
            }

            @Override
            public Command withCount(int count) {
                return wrapped;
            }

            public String toString() {
                return String.format("dontRepeat(%s)", wrapped);
            }
        };
    }

    public static Command repeat(int count, Command command) {
        return new MultipleExecutionCommand(count, command);
    }

    public static Command motionCmd(Motion motion) {
        return new MotionCommand(motion);
    }

    public static Command cmd(Command command) {
        return command;
    }
}

