/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.commandline.SearchMode;

public class ChangeToSearchModeCommand
extends CountAwareCommand {
    private boolean backwards;
    private Command executeOnCompletion;
    private boolean fromVisual;

    public ChangeToSearchModeCommand(boolean backwards, Command executeOnCompletion) {
        this.backwards = backwards;
        this.executeOnCompletion = executeOnCompletion;
    }

    public ChangeToSearchModeCommand(boolean backwards, Command executeOnCompletion, boolean fromVisual) {
        this.backwards = backwards;
        this.executeOnCompletion = executeOnCompletion;
        this.fromVisual = fromVisual;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        SearchMode.Direction direction = this.backwards ? SearchMode.Direction.BACKWARD : SearchMode.Direction.FORWARD;
        ExecuteCommandHint.OnLeave onLeaveCmd = new ExecuteCommandHint.OnLeave((Command)this.executeOnCompletion.withCount(count));
        if (this.fromVisual) {
            editorAdaptor.changeMode("search mode", direction, SearchMode.FROM_VISUAL, onLeaveCmd);
        } else {
            editorAdaptor.changeMode("search mode", direction, onLeaveCmd);
        }
    }

    @Override
    public CountAwareCommand repetition() {
        return null;
    }
}

