/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.ChangeOperationRepetition;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CommandWrappers;
import net.sourceforge.vrapper.vim.commands.DeleteOperation;
import net.sourceforge.vrapper.vim.commands.InsertLineCommand;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.TextOperationTextObjectCommand;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;

public class ChangeOperation
implements TextOperation {
    public static final ChangeOperation INSTANCE = new ChangeOperation();

    protected ChangeOperation() {
    }

    @Override
    public TextOperation repetition() {
        return ChangeOperationRepetition.INSTANCE;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count, TextObject textObject) throws CommandExecutionException {
        Command beforeInsertCmd = ChangeOperation.getHintCommand(editorAdaptor, count, textObject);
        editorAdaptor.changeMode("insert mode", new ExecuteCommandHint.OnEnter(beforeInsertCmd));
    }

    static Command getHintCommand(EditorAdaptor editorAdaptor, int count, TextObject textObject) throws CommandExecutionException {
        Command result = new TextOperationTextObjectCommand(DeleteOperation.INSTANCE, textObject).withCount(count);
        TextRange region = textObject.getRegion(editorAdaptor, count);
        ContentType contentType = textObject.getContentType(editorAdaptor.getConfiguration());
        TextContent txtContent = editorAdaptor.getModelContent();
        int position = region.getLeftBound().getModelOffset();
        int length = region.getModelLength();
        String text = txtContent.getText(position, length);
        if (!(contentType != ContentType.LINES || position <= 0 || text.length() != 0 && VimUtils.isNewLine(text.substring(text.length() - 1)))) {
            result = CommandWrappers.seq(result, InsertLineCommand.POST_CURSOR);
        } else if (ContentType.LINES.equals((Object)contentType)) {
            result = CommandWrappers.seq(result, InsertLineCommand.PRE_CURSOR);
        }
        return result;
    }
}

