/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.ViewportService;
import net.sourceforge.vrapper.utils.ViewPortInformation;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.motions.ViewPortMotion;

public class CenterLineCommand
extends CountIgnoringNonRepeatableCommand {
    public static final CenterLineCommand CENTER = new CenterLineCommand(ViewPortMotion.Type.MIDDLE);
    public static final CenterLineCommand TOP = new CenterLineCommand(ViewPortMotion.Type.HIGH);
    public static final CenterLineCommand BOTTOM = new CenterLineCommand(ViewPortMotion.Type.LOW);
    private final ViewPortMotion.Type type;

    private CenterLineCommand(ViewPortMotion.Type type) {
        this.type = type;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor) {
        int line = editorAdaptor.getViewContent().getLineInformationOfOffset(editorAdaptor.getPosition().getViewOffset()).getNumber();
        this.doIt(editorAdaptor, line);
    }

    public void doIt(EditorAdaptor editorAdaptor, int line) {
        ViewportService view = editorAdaptor.getViewportService();
        ViewPortInformation info = view.getViewPortInformation();
        int scrolloff = editorAdaptor.getConfiguration().get(Options.SCROLL_OFFSET);
        int middle = this.type.calculateLine(info, scrolloff);
        int offset = line - middle;
        int target = Math.max(info.getTopLine() + offset, 0);
        view.setTopLine(target);
    }
}

