/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.commands.BlockPasteHelper;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountAwareCommand;
import net.sourceforge.vrapper.vim.commands.DeleteOperation;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.SelectionBasedTextOperationCommand;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.TextBlockRegisterContent;

public class BlockwisePasteCommand
extends CountAwareCommand {
    public static final BlockwisePasteCommand INSTANCE = new BlockwisePasteCommand();

    @Override
    public CountAwareCommand repetition() {
        return null;
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (count == 0) {
            count = 1;
        }
        editorAdaptor.rememberLastActiveSelection();
        BlockWiseSelection selection = (BlockWiseSelection)editorAdaptor.getSelection();
        TextContent content = editorAdaptor.getModelContent();
        BlockWiseSelection.TextBlock rect = BlockWiseSelection.getTextBlock(selection.getFrom(), selection.getTo(), content, editorAdaptor.getCursorService());
        TextRange blockRange = selection.getRegion(editorAdaptor, 0);
        RegisterContent registerContent = editorAdaptor.getRegisterManager().getActiveRegister().getContent();
        ContentType pastingContentType = registerContent.getPayloadType();
        HistoryService history = editorAdaptor.getHistory();
        history.beginCompoundChange();
        history.lock("block-paste");
        try {
            SelectionBasedTextOperationCommand.doIt(editorAdaptor, 0, DeleteOperation.INSTANCE, content, blockRange, true);
            int position = blockRange.getLeftBound().getModelOffset();
            switch (pastingContentType) {
                case TEXT: {
                    TextBlockRegisterContent repl = new TextBlockRegisterContent(0, VimConstants.REGISTER_NEWLINE);
                    String text = StringUtils.multiply(VimUtils.replaceNewLines(registerContent.getText(), ""), count);
                    int l = rect.startLine;
                    while (l <= rect.endLine) {
                        repl.appendLine(text);
                        ++l;
                    }
                    position = BlockPasteHelper.execute(editorAdaptor, 1, 0, false, repl, blockRange.getLeftBound());
                    break;
                }
                case TEXT_RECTANGLE: {
                    position = BlockPasteHelper.execute(editorAdaptor, count, 0, false, registerContent, blockRange.getLeftBound());
                    break;
                }
                case LINES: {
                    String text = StringUtils.multiply(registerContent.getText(), count);
                    String newLine = editorAdaptor.getConfiguration().getNewLine();
                    text = String.valueOf(newLine) + VimUtils.stripLastNewline(VimUtils.replaceNewLines(text, newLine));
                    int pastePos = content.getLineInformation(rect.endLine).getEndOffset();
                    content.replace(pastePos, 0, text);
                    LineInformation firstPastedLine = content.getLineInformation(rect.endLine + 1);
                    position = VimUtils.getFirstNonWhiteSpaceOffset(content, firstPastedLine);
                    break;
                }
            }
            Position destination = editorAdaptor.getCursorService().newPositionForModelOffset(position);
            editorAdaptor.setPosition(destination, StickyColumnPolicy.ON_CHANGE);
        }
        finally {
            history.unlock("block-paste");
            history.endCompoundChange();
            LeaveVisualModeCommand.doIt(editorAdaptor);
        }
    }
}

