/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractSelection;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.register.TextBlockRegisterContent;

public class BlockWiseSelection
extends AbstractSelection {
    private final Position from;
    private final Position to;
    private final TextRange range;

    public BlockWiseSelection(EditorAdaptor editor, Position from, Position to) {
        this.from = from;
        this.to = to;
        this.range = StartEndTextRange.exclusive(from, to);
    }

    @Override
    public String getModeName() {
        return "block visual mode";
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorMode, int count) throws CommandExecutionException {
        return this.range;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public TextObject withCount(int count) {
        return this;
    }

    @Override
    public Position getEnd() {
        return this.range.getEnd();
    }

    @Override
    public Position getLeftBound() {
        return this.range.getLeftBound();
    }

    @Override
    public int getModelLength() {
        return this.range.getModelLength();
    }

    @Override
    public Position getRightBound() {
        return this.range.getRightBound();
    }

    @Override
    public Position getStart() {
        return this.range.getStart();
    }

    @Override
    public int getViewLength() {
        return this.range.getViewLength();
    }

    @Override
    public boolean isReversed() {
        return this.range.isReversed();
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return ContentType.TEXT_RECTANGLE;
    }

    @Override
    public Position getFrom() {
        return this.from;
    }

    @Override
    public Position getTo() {
        return this.to;
    }

    public String toString() {
        String caretInfo = "";
        if (this.range != null && this.to != null && this.range.getEnd() != this.to) {
            caretInfo = " @ M" + this.to.getModelOffset() + "/" + this.to.getViewOffset() + "V";
        }
        return "BlockWiseSelection( " + String.valueOf(this.range) + caretInfo + " )";
    }

    public static TextBlock getTextBlock(Position from, Position to, TextContent textContent, CursorService cursorService) {
        LineInformation fromLine = textContent.getLineInformationOfOffset(from.getModelOffset());
        LineInformation toLine = textContent.getLineInformationOfOffset(to.getModelOffset());
        int fromLineNo = fromLine.getNumber();
        int toLineNo = toLine.getNumber();
        TextBlock result = new TextBlock();
        if (fromLineNo < toLineNo) {
            result.startLine = fromLineNo;
            result.endLine = toLineNo;
        } else {
            result.startLine = toLineNo;
            result.endLine = fromLineNo;
        }
        result.endLine = Math.min(result.endLine, textContent.getNumberOfLines() - 1);
        int fromVOffset = cursorService.getVisualOffset(from);
        int toVOffset = cursorService.getVisualOffset(to);
        if (fromVOffset < toVOffset) {
            result.startVisualOffset = fromVOffset;
            result.endVisualOffset = toVOffset;
        } else {
            result.startVisualOffset = toVOffset;
            result.endVisualOffset = fromVOffset;
        }
        if (cursorService.shouldStickToEOL()) {
            result.endVisualOffset = result.startVisualOffset;
            int i = result.startLine;
            while (i <= result.endLine) {
                LineInformation line = textContent.getLineInformation(i);
                int lastOfs = cursorService.getVisualOffset(cursorService.shiftPositionForModelOffset(line.getEndOffset(), -1, false));
                result.endVisualOffset = Math.max(result.endVisualOffset, lastOfs);
                ++i;
            }
        }
        return result;
    }

    public static TextBlockRegisterContent getTextBlockContent(EditorAdaptor editorAdaptor, TextRange range) {
        TextContent textContent = editorAdaptor.getModelContent();
        CursorService cursorService = editorAdaptor.getCursorService();
        TextBlock textBlock = BlockWiseSelection.getTextBlock(range.getStart(), range.getEnd(), editorAdaptor.getModelContent(), cursorService);
        TextBlockRegisterContent blockContent = new TextBlockRegisterContent(textBlock.endVisualOffset - textBlock.startVisualOffset, editorAdaptor.getConfiguration().getNewLine());
        int line = textBlock.startLine;
        while (line <= textBlock.endLine) {
            LineInformation lineInformation = textContent.getLineInformation(line);
            Position start = cursorService.getPositionByVisualOffset(line, textBlock.startVisualOffset);
            if (start == null || lineInformation.getLength() == 0) {
                blockContent.appendLine("");
            } else {
                int startOfs = start.getModelOffset();
                Position end = cursorService.getPositionByVisualOffset(line, textBlock.endVisualOffset);
                int endOfs = end == null ? lineInformation.getEndOffset() : end.addModelOffset(1).getModelOffset();
                blockContent.appendLine(textContent.getText(startOfs, endOfs - startOfs));
            }
            ++line;
        }
        return blockContent;
    }

    @Override
    public Position getStartMark(EditorAdaptor defaultEditorAdaptor) {
        return this.getFrom();
    }

    @Override
    public Position getEndMark(EditorAdaptor defaultEditorAdaptor) {
        return this.getTo();
    }

    @Override
    public Selection doReset(EditorAdaptor adaptor, Position from, Position to) {
        return new BlockWiseSelection(adaptor, from, to);
    }

    public static final class TextBlock {
        public int startLine;
        public int endLine;
        public int startVisualOffset;
        public int endVisualOffset;
    }
}

