/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.Selection;

public abstract class AbstractSelection
implements Selection {
    @Override
    public Selection reset(EditorAdaptor editorAdaptor, Position from, Position to) {
        boolean isSelectionInclusive = "inclusive".equals(editorAdaptor.getConfiguration().get(Options.SELECTION));
        int docLength = editorAdaptor.getModelContent().getTextLength();
        CursorService cursorService = editorAdaptor.getCursorService();
        if (from.getModelOffset() >= docLength && isSelectionInclusive) {
            from = cursorService.shiftPositionForModelOffset(docLength, -1, true);
        } else if (from.getModelOffset() > docLength) {
            from = cursorService.newPositionForModelOffset(docLength);
        }
        if (to.getModelOffset() >= docLength && isSelectionInclusive) {
            to = cursorService.shiftPositionForModelOffset(docLength, -1, true);
        } else if (to.getModelOffset() > docLength) {
            to = cursorService.newPositionForModelOffset(docLength);
        }
        return this.doReset(editorAdaptor, from, to);
    }

    protected abstract Selection doReset(EditorAdaptor var1, Position var2, Position var3);
}

