/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.platform.SimpleConfiguration;
import net.sourceforge.vrapper.utils.VimUtils;

public class VimConstants {
    public static final Set<String> WHITESPACE = VimUtils.set(" ", "\t", "\n", "\r");
    public static final Set<String> NEWLINE = VimConstants.createNewlineSet();
    public static final Set<KeyStroke> PRINTABLE_KEYSTROKES = VimConstants.createPrintableKeyStrokes();
    public static final Set<KeyStroke> PRINTABLE_KEYSTROKES_WITH_NL = VimConstants.createPrintableKeyStrokesWithNL();
    public static final Set<SpecialKey> SPECIAL_KEYS_ALLOWED_FOR_UNMODIFIABLE_INSERT = VimConstants.createSpecialKeysAllowedForUnmodifiableInsert();
    public static final Set<SpecialKey> SPECIAL_KEYS_ALLOWED_FOR_INSERT = VimConstants.createSpecialKeysAllowedForInsert();
    public static final String SPACE = " ";
    public static final String PATTERN_DELIM_PATTERN = "[^A-Za-z0-9]";
    public static final String REGISTER_NEWLINE = System.getProperty("line.separator");
    public static final String BACKWARD_SEARCH_CHAR = "?";
    public static final String FORWARD_SEARCH_CHAR = "/";
    public static final String COMMAND_LINE_CHAR = ":";
    public static final String ESCAPE_CHAR = "\\";

    private static Set<String> createNewlineSet() {
        SimpleConfiguration.NewLine[] newlines = SimpleConfiguration.NewLine.values();
        String[] nl = new String[newlines.length];
        int i = 0;
        while (i < nl.length) {
            nl[i] = newlines[i].nl;
            ++i;
        }
        return VimUtils.set(nl);
    }

    private static Set<KeyStroke> createPrintableKeyStrokes() {
        HashSet<KeyStroke> result = new HashSet<KeyStroke>();
        char c = ' ';
        while (c <= '\u00ff') {
            result.add(ConstructorWrappers.key(c));
            c = (char)(c + '\u0001');
        }
        return Collections.unmodifiableSet(result);
    }

    private static Set<KeyStroke> createPrintableKeyStrokesWithNL() {
        HashSet<KeyStroke> result = new HashSet<KeyStroke>(VimConstants.createPrintableKeyStrokes());
        result.add(ConstructorWrappers.key(SpecialKey.RETURN));
        return Collections.unmodifiableSet(result);
    }

    private static Set<SpecialKey> createSpecialKeysAllowedForUnmodifiableInsert() {
        return VimUtils.set(SpecialKey.ARROW_LEFT, SpecialKey.ARROW_RIGHT, SpecialKey.ARROW_UP, SpecialKey.ARROW_DOWN);
    }

    private static Set<SpecialKey> createSpecialKeysAllowedForInsert() {
        return VimUtils.set(SpecialKey.BACKSPACE, SpecialKey.RETURN, SpecialKey.ARROW_LEFT, SpecialKey.ARROW_RIGHT, SpecialKey.ARROW_UP, SpecialKey.ARROW_DOWN, SpecialKey.TAB);
    }
}

