/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.sourceforge.vrapper.keymap.KeyMap;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.Remapping;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.utils.CollectionUtils;
import net.sourceforge.vrapper.vim.RemappedKeyStroke;

public class KeyStrokeTranslator {
    private State<Remapping> currentState;
    private Remapping lastValue;
    private final List<RemappedKeyStroke> unconsumedKeyStrokes = new LinkedList<RemappedKeyStroke>();
    private final List<RemappedKeyStroke> originalKeyStrokes = new LinkedList<RemappedKeyStroke>();
    private final LinkedList<RemappedKeyStroke> resultingKeyStrokes = new LinkedList();
    private boolean mappingSucceeded = false;

    public boolean processKeyStroke(KeyMap keymap, KeyStroke key) {
        Transition<Remapping> trans;
        if (this.currentState == null) {
            trans = keymap.press(key);
            if (trans == null) {
                return false;
            }
            this.resultingKeyStrokes.clear();
            this.unconsumedKeyStrokes.clear();
            this.originalKeyStrokes.clear();
            this.mappingSucceeded = false;
        } else {
            trans = this.currentState.press(key);
        }
        if (trans != null) {
            this.originalKeyStrokes.add(new RemappedKeyStroke(key, false));
            if (trans.getValue() != null) {
                this.lastValue = trans.getValue();
                this.unconsumedKeyStrokes.clear();
                this.mappingSucceeded = true;
            } else {
                boolean recursive = !this.unconsumedKeyStrokes.isEmpty() || this.lastValue != null;
                this.unconsumedKeyStrokes.add(new RemappedKeyStroke(key, recursive));
            }
            if (trans.getNextState() == null) {
                this.prependLastValue();
                this.currentState = null;
            } else {
                this.currentState = trans.getNextState();
            }
        } else {
            this.unconsumedKeyStrokes.add(new RemappedKeyStroke(key, true));
            this.prependUnconsumed();
            this.prependLastValue();
            this.currentState = null;
            this.mappingSucceeded = false;
        }
        return true;
    }

    public Queue<RemappedKeyStroke> originalKeyStrokes() {
        if (this.originalKeyStrokes.isEmpty()) {
            return CollectionUtils.emptyQueue();
        }
        return new LinkedList<RemappedKeyStroke>(this.originalKeyStrokes);
    }

    public Queue<RemappedKeyStroke> resultingKeyStrokes() {
        if (this.resultingKeyStrokes.isEmpty()) {
            return CollectionUtils.emptyQueue();
        }
        return new LinkedList<RemappedKeyStroke>(this.resultingKeyStrokes);
    }

    public boolean didMappingSucceed() {
        return this.mappingSucceeded;
    }

    private void prependUnconsumed() {
        int i = 0;
        while (i < this.unconsumedKeyStrokes.size()) {
            KeyStroke key = this.unconsumedKeyStrokes.get(i);
            if (KeyMap.GLOBAL_MAP.containsKey(key)) {
                this.unconsumedKeyStrokes.set(i, new RemappedKeyStroke(KeyMap.GLOBAL_MAP.get(key), false));
            }
            ++i;
        }
        this.resultingKeyStrokes.addAll(0, this.unconsumedKeyStrokes);
        this.unconsumedKeyStrokes.clear();
    }

    private void prependLastValue() {
        if (this.lastValue == null) {
            return;
        }
        boolean recursive = this.lastValue.isRecursive();
        int i = 0;
        for (KeyStroke key : this.lastValue.getKeyStrokes()) {
            this.resultingKeyStrokes.add(i++, new RemappedKeyStroke(key, recursive));
        }
        this.lastValue = null;
    }
}

