/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.vrapper.keymap.KeyMap;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.keymap.vim.SimpleKeyStroke;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.BufferAndTabService;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.FileService;
import net.sourceforge.vrapper.platform.HighlightingService;
import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.platform.KeyMapProvider;
import net.sourceforge.vrapper.platform.Platform;
import net.sourceforge.vrapper.platform.PlatformSpecificModeProvider;
import net.sourceforge.vrapper.platform.PlatformSpecificStateProvider;
import net.sourceforge.vrapper.platform.PlatformSpecificTextObjectProvider;
import net.sourceforge.vrapper.platform.PlatformVrapperLifecycleListener;
import net.sourceforge.vrapper.platform.SearchAndReplaceService;
import net.sourceforge.vrapper.platform.SelectionService;
import net.sourceforge.vrapper.platform.ServiceProvider;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.platform.UnderlyingEditorSettings;
import net.sourceforge.vrapper.platform.UserInterfaceService;
import net.sourceforge.vrapper.platform.ViewportService;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchResult;
import net.sourceforge.vrapper.utils.SelectionArea;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.UnmodifiableTextContentDecorator;
import net.sourceforge.vrapper.vim.DefaultTextObjectProvider;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.KeyStrokeTranslator;
import net.sourceforge.vrapper.vim.LocalConfiguration;
import net.sourceforge.vrapper.vim.MacroAbortedException;
import net.sourceforge.vrapper.vim.MacroPlayer;
import net.sourceforge.vrapper.vim.MacroRecorder;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.RemappedKeyStroke;
import net.sourceforge.vrapper.vim.TextObjectProvider;
import net.sourceforge.vrapper.vim.VrapperEventListener;
import net.sourceforge.vrapper.vim.VrapperEventListeners;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.RecordMacroMode;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.YankOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.AbstractVisualMode;
import net.sourceforge.vrapper.vim.modes.BlockwiseVisualMode;
import net.sourceforge.vrapper.vim.modes.ConfirmSubstitutionMode;
import net.sourceforge.vrapper.vim.modes.ContentAssistMode;
import net.sourceforge.vrapper.vim.modes.EditorMode;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.modes.LinewiseVisualMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.NormalMode;
import net.sourceforge.vrapper.vim.modes.ReplaceMode;
import net.sourceforge.vrapper.vim.modes.TempLinewiseVisualMode;
import net.sourceforge.vrapper.vim.modes.TempNormalMode;
import net.sourceforge.vrapper.vim.modes.TempVisualMode;
import net.sourceforge.vrapper.vim.modes.VisualMode;
import net.sourceforge.vrapper.vim.modes.commandline.CommandLineMode;
import net.sourceforge.vrapper.vim.modes.commandline.CommandLineParser;
import net.sourceforge.vrapper.vim.modes.commandline.MessageMode;
import net.sourceforge.vrapper.vim.modes.commandline.PasteRegisterMode;
import net.sourceforge.vrapper.vim.modes.commandline.SearchMode;
import net.sourceforge.vrapper.vim.register.DefaultRegisterManager;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterManager;

public class DefaultEditorAdaptor
implements EditorAdaptor {
    public static boolean SHOULD_READ_RC_FILE = true;
    private static final String CONFIG_FILE_NAME = ".vrapperrc";
    private static final String WINDOWS_CONFIG_FILE_NAME = "_vrapperrc";
    protected EditorMode currentMode;
    private final Map<String, EditorMode> modeMap = new HashMap<String, EditorMode>();
    private final TextContent modelContent;
    private final TextContent viewContent;
    private final CursorService cursorService;
    private final SelectionService selectionService;
    private final FileService fileService;
    private final BufferAndTabService bufferAndTabService;
    private RegisterManager registerManager;
    private final RegisterManager globalRegisterManager;
    private final ViewportService viewportService;
    private final HistoryService historyService;
    private final UserInterfaceService userInterfaceService;
    private final ServiceProvider serviceProvider;
    private final KeyStrokeTranslator keyStrokeTranslator;
    private final KeyMapProvider keyMapProvider;
    private final DefaultTextObjectProvider textObjectProvider;
    private final UnderlyingEditorSettings editorSettings;
    private final LocalConfiguration configuration;
    private final PlatformSpecificStateProvider platformSpecificStateProvider;
    private final PlatformSpecificModeProvider platformSpecificModeProvider;
    private final SearchAndReplaceService searchAndReplaceService;
    private final HighlightingService highlightingService;
    private MacroRecorder macroRecorder;
    private MacroPlayer macroPlayer;
    private Deque<String> macroStack;
    private Deque<String> mappingStack;
    boolean abortRecursion;
    private String recursionErrorMessage;
    private String lastModeName;
    private String editorType;
    private VrapperEventListeners listeners;
    private Selection lastSelection;
    private SearchResult searchResult;
    private int cursorBeforeMapping = -1;

    public DefaultEditorAdaptor(Platform editor, RegisterManager registerManager, boolean isActive, List<PlatformVrapperLifecycleListener> lifecycleListeners) {
        this.configuration = editor.getConfiguration();
        this.userInterfaceService = editor.getUserInterfaceService();
        this.modelContent = new UnmodifiableTextContentDecorator(editor.getModelContent(), this.configuration, editor);
        this.viewContent = new UnmodifiableTextContentDecorator(editor.getViewContent(), this.configuration, editor);
        this.cursorService = editor.getCursorService();
        this.selectionService = editor.getSelectionService();
        this.historyService = editor.getHistoryService();
        this.registerManager = registerManager;
        this.globalRegisterManager = registerManager;
        this.serviceProvider = editor.getServiceProvider();
        this.editorSettings = editor.getUnderlyingEditorSettings();
        this.textObjectProvider = new DefaultTextObjectProvider();
        PlatformSpecificTextObjectProvider specificTextObjectProvider = editor.getPlatformSpecificTextObjectProvider();
        if (specificTextObjectProvider != null) {
            this.textObjectProvider.updateDelimitedTexts(specificTextObjectProvider.delimitedTexts());
            this.textObjectProvider.updateTextObjects(specificTextObjectProvider.textObjects());
        }
        this.platformSpecificStateProvider = editor.getPlatformSpecificStateProvider(this.textObjectProvider);
        this.platformSpecificModeProvider = editor.getPlatformSpecificModeProvider();
        this.searchAndReplaceService = editor.getSearchAndReplaceService();
        this.viewportService = editor.getViewportService();
        this.highlightingService = editor.getHighlightingService();
        this.keyMapProvider = editor.getKeyMapProvider();
        this.keyStrokeTranslator = new KeyStrokeTranslator();
        this.macroRecorder = new MacroRecorder(registerManager, this.userInterfaceService);
        this.macroPlayer = null;
        this.macroStack = new LinkedList<String>();
        this.mappingStack = new LinkedList<String>();
        this.editorType = editor.getEditorType();
        this.listeners = new VrapperEventListeners(this);
        this.fileService = editor.getFileService();
        this.bufferAndTabService = editor.getBufferAndTabService();
        this.__set_modes(this);
        this.setNewLineFromFirstLine();
        if (isActive) {
            this.changeModeSafely("normal mode", new ModeSwitchHint[0]);
        }
        this.readConfiguration();
        for (PlatformVrapperLifecycleListener listener : lifecycleListeners) {
            try {
                listener.editorConfigured(this, isActive);
            }
            catch (Exception e) {
                VrapperLog.error("Lifecycle listener " + listener.getClass() + " threw exception " + " for file '" + this.fileService.getCurrentFilePath() + "' when firing " + "'editorConfigured' method.", e);
            }
        }
        if ("matchreadonly".equals(this.configuration.get(Options.SYNC_MODIFIABLE)) && !this.configuration.isSet(Options.MODIFIABLE)) {
            this.configuration.set(Options.MODIFIABLE, !this.fileService.isReadOnly());
        }
        String highlightScope = this.configuration.get(Options.SEARCH_HL_SCOPE);
        if (this.configuration.get(Options.SEARCH_HIGHLIGHT).booleanValue() && "window".equals(highlightScope)) {
            try {
                Search lastSearch = registerManager.getSearch();
                if (lastSearch != null) {
                    this.searchAndReplaceService.highlight(lastSearch);
                }
            }
            catch (VrapperPlatformException e) {
                VrapperLog.error("Failed to initialize highlighting in editor", e);
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String getLastModeName() {
        return this.lastModeName;
    }

    public void __set_modes(DefaultEditorAdaptor self) {
        EditorMode[] modes;
        this.modeMap.clear();
        EditorMode[] editorModeArray = modes = new EditorMode[]{new NormalMode(self), new RecordMacroMode(self), new TempNormalMode(self), new VisualMode(self), new TempVisualMode(self), new LinewiseVisualMode(self), new TempLinewiseVisualMode(self), new BlockwiseVisualMode(self), new InsertMode(self), new ReplaceMode(self), new CommandLineMode(self), new SearchMode(self), new ConfirmSubstitutionMode(self), new MessageMode(self), new ContentAssistMode(self), new PasteRegisterMode(self)};
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            EditorMode mode = editorModeArray[n2];
            this.modeMap.put(mode.getName(), mode);
            ++n2;
        }
    }

    @Override
    public void changeModeSafely(String name, ModeSwitchHint ... hints) {
        try {
            this.changeMode(name, hints);
        }
        catch (CommandExecutionException e) {
            VrapperLog.error("exception when changing mode", e);
            this.userInterfaceService.setErrorMessage(e.getMessage());
        }
        catch (RuntimeException e) {
            VrapperLog.error("unexpected exception when changing mode", e);
            this.userInterfaceService.setErrorMessage("error while changing to mode " + name);
        }
    }

    private void setNewLineFromFirstLine() {
        if (this.modelContent.getNumberOfLines() > 1) {
            LineInformation first = this.modelContent.getLineInformation(0);
            LineInformation second = this.modelContent.getLineInformation(1);
            int start = first.getEndOffset();
            int end = second.getBeginOffset();
            String newLine = this.modelContent.getText(start, end - start);
            this.configuration.setNewLine(newLine);
        }
    }

    private void readConfiguration() {
        if (!SHOULD_READ_RC_FILE) {
            return;
        }
        try {
            String filename;
            this.configuration.setListenersEnabled(false);
            String overrideVrapperRcFile = System.getProperty("vrapper.vrapperrc");
            boolean alternateRCLoaded = false;
            if (overrideVrapperRcFile != null && overrideVrapperRcFile.trim().length() > 0 && !(alternateRCLoaded = this.sourceConfigurationFile(overrideVrapperRcFile.trim()))) {
                VrapperLog.error("Failed to load alternate vrapperrc [" + overrideVrapperRcFile + "]");
            }
            if (!(alternateRCLoaded || this.sourceConfigurationFile(filename = CONFIG_FILE_NAME) || this.sourceConfigurationFile(filename = WINDOWS_CONFIG_FILE_NAME))) {
                VrapperLog.info("No .vrapperrc or _vrapperrc found.");
            }
        }
        finally {
            this.configuration.setListenersEnabled(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean sourceConfigurationFile(String filename) {
        File config = new File(filename);
        if (!config.isAbsolute()) {
            File homeDir = new File(System.getProperty("user.home"));
            config = filename.startsWith("~/") || filename.startsWith("~\\") ? new File(homeDir, filename.substring(2)) : new File(homeDir, filename);
        }
        int lineNr = 0;
        if (!config.exists()) return false;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(config), "UTF-8"));
            CommandLineMode cmdLineMode = (CommandLineMode)this.modeMap.get("command mode");
            CommandLineParser parser = cmdLineMode.createParser();
            block14: while ((line = reader.readLine()) != null) {
                Command c;
                ++lineNr;
                String trimmed = line.trim().toLowerCase();
                if (trimmed.equals("") || trimmed.startsWith("\"") || trimmed.contains("<silent>")) continue;
                if (trimmed.startsWith("if")) {
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().toLowerCase().startsWith("endif")) continue block14;
                    }
                    continue;
                }
                if (trimmed.startsWith("func")) {
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().toLowerCase().startsWith("endfunc")) continue block14;
                    }
                    continue;
                }
                if (trimmed.startsWith("try")) {
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().toLowerCase().startsWith("endtry")) continue block14;
                    }
                    continue;
                }
                if (trimmed.startsWith(":")) {
                    line = line.substring(line.indexOf(58) + 1);
                }
                if ((c = parser.parseAndExecute(null, line.trim())) == null) continue;
                c.execute(this);
            }
        }
        catch (IOException e) {
            VrapperLog.error("Failed to parse .vrapperrc", e);
            if (reader == null) return true;
            try {
                reader.close();
                return true;
            }
            catch (IOException iOException) {
                VrapperLog.error("Failed to close reader to .vrapperrc");
            }
            return true;
        }
        catch (CommandExecutionException e) {
            try {
                VrapperLog.error("Failed to execute command on line " + lineNr + " of .vrapperrc", e);
                if (reader == null) return true;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    VrapperLog.error("Failed to close reader to .vrapperrc");
                }
                throw throwable;
            }
            try {
                reader.close();
                return true;
            }
            catch (IOException iOException) {
                VrapperLog.error("Failed to close reader to .vrapperrc");
            }
            return true;
        }
        if (reader == null) return true;
        try {
            reader.close();
            return true;
        }
        catch (IOException iOException) {
            VrapperLog.error("Failed to close reader to .vrapperrc");
        }
        return true;
    }

    @Override
    public void changeMode(String modeName, ModeSwitchHint ... args) throws CommandExecutionException {
        EditorMode newMode = this.modeMap.get(modeName);
        if (newMode == null) {
            newMode = this.getMode(modeName);
        }
        if (this.currentMode != newMode) {
            this.listeners.fireModeAboutToSwitch(newMode);
            EditorMode oldMode = this.currentMode;
            if (this.currentMode != null) {
                this.currentMode.leaveMode(args);
                this.lastModeName = this.currentMode.getName();
            }
            try {
                this.currentMode = newMode;
                newMode.enterMode(args);
                this.userInterfaceService.setEditorMode(this.currentMode.getDisplayName());
                this.listeners.fireModeSwitched(oldMode);
            }
            catch (Exception e) {
                this.currentMode = oldMode;
                RuntimeException result = null;
                try {
                    oldMode.enterMode(new ModeSwitchHint[0]);
                }
                catch (Exception e2) {
                    String msg = "Failed to switch to mode " + newMode + " and failed to switch back to " + oldMode.getName();
                    VrapperLog.error(msg, e);
                    EditorMode temp = this.modeMap.get("normal mode");
                    temp.enterMode(new ModeSwitchHint[0]);
                    oldMode = temp;
                    this.currentMode = temp;
                    result = new RuntimeException(msg, e2);
                }
                this.userInterfaceService.setEditorMode(this.currentMode.getDisplayName());
                this.listeners.fireModeSwitched(oldMode);
                if (result == null && e instanceof CommandExecutionException) {
                    throw (CommandExecutionException)e;
                }
                if (result == null) {
                    throw new RuntimeException("Failed to switch to mode " + newMode, e);
                }
                throw result;
            }
        }
    }

    @Override
    public boolean handleKey(KeyStroke key) {
        try {
            this.macroRecorder.handleKey(key);
            boolean bl = this.handleKeyOffRecord(key);
            return bl;
        }
        catch (MacroAbortedException e) {
            this.changeModeSafely("normal mode", new ModeSwitchHint[0]);
            if (this.recursionErrorMessage == null) {
                this.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
            return true;
        }
        finally {
            this.macroStack.clear();
            this.mappingStack.clear();
            this.macroPlayer = null;
            this.abortRecursion = false;
            if (this.recursionErrorMessage != null) {
                this.userInterfaceService.setErrorMessage(this.recursionErrorMessage);
            }
            this.recursionErrorMessage = null;
        }
    }

    @Override
    public boolean handleKeyOffRecord(KeyStroke key) {
        boolean result = this.handleKey0(key);
        if (this.macroPlayer != null) {
            MacroPlayer player = this.macroPlayer;
            this.macroPlayer = null;
            player.play(this.macroStack);
        }
        return result;
    }

    @Override
    public TextContent getModelContent() {
        return this.modelContent;
    }

    @Override
    public TextContent getViewContent() {
        return this.viewContent;
    }

    @Override
    public Position getPosition() {
        return this.cursorService.getPosition();
    }

    @Override
    public void setPosition(Position destination, StickyColumnPolicy stickyColumnPolicy) {
        this.cursorService.setPosition(destination, stickyColumnPolicy);
    }

    @Override
    public Selection getSelection() {
        return this.selectionService.getSelection();
    }

    @Override
    public void setSelection(Selection selection) {
        Set<String> cbOption = this.configuration.get(Options.CLIPBOARD);
        if (selection != null && selection.getModelLength() > 0 && this.currentMode instanceof AbstractVisualMode) {
            ContentType contentType;
            TextRange textRange;
            Register activeRegister = this.registerManager.getActiveRegister();
            try {
                textRange = selection.getRegion(this, 0);
                contentType = selection.getContentType(this.configuration);
            }
            catch (CommandExecutionException e) {
                VrapperLog.error("Failed to get properties of selection!", e);
                return;
            }
            if (cbOption.contains("autoselect")) {
                this.registerManager.setActiveRegister("*");
                YankOperation.doIt(this, textRange, contentType, false, false);
            }
            if (cbOption.contains("autoselectplus")) {
                this.registerManager.setActiveRegister("+");
                YankOperation.doIt(this, textRange, contentType, false, false);
            }
            this.registerManager.setActiveRegister(activeRegister);
        }
        this.selectionService.setSelection(selection);
    }

    @Override
    public void setNativeSelection(TextRange range) {
        this.selectionService.setNativeSelection(range);
    }

    @Override
    public TextRange getNativeSelection() {
        return this.selectionService.getNativeSelection();
    }

    @Override
    public BufferAndTabService getBufferAndTabService() {
        return this.bufferAndTabService;
    }

    @Override
    public CursorService getCursorService() {
        return this.cursorService;
    }

    @Override
    public FileService getFileService() {
        return this.fileService;
    }

    @Override
    public ViewportService getViewportService() {
        return this.viewportService;
    }

    @Override
    public UserInterfaceService getUserInterfaceService() {
        return this.userInterfaceService;
    }

    @Override
    public RegisterManager getRegisterManager() {
        return this.registerManager;
    }

    @Override
    public HistoryService getHistory() {
        return this.historyService;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        return this.serviceProvider.getService(serviceClass);
    }

    @Override
    public EditorMode getMode(String modeName) {
        EditorMode result = this.modeMap.get(modeName);
        if (modeName != null && result == null) {
            try {
                List<EditorMode> modes = this.platformSpecificModeProvider.getModes(this);
                for (EditorMode mode : modes) {
                    if (this.modeMap.containsKey(mode.getName())) {
                        VrapperLog.error(String.format("Mode '%s' was already loaded! Mode in registry '%s', conflicting mode '%s'", mode.getName(), this.modeMap.get(mode.getName()).getClass().getName(), mode.getClass().getName()));
                        continue;
                    }
                    this.modeMap.put(mode.getName(), mode);
                }
                result = this.modeMap.get(modeName);
                if (result == null) {
                    String message = String.format("There is no mode named '%s'", modeName);
                    throw new CommandExecutionException(message);
                }
            }
            catch (CommandExecutionException e) {
                VrapperLog.error("Failed to get mode '" + modeName + "'", e);
                throw new VrapperPlatformException(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public KeyMapProvider getKeyMapProvider() {
        return this.keyMapProvider;
    }

    @Override
    public TextObjectProvider getTextObjectProvider() {
        return this.textObjectProvider;
    }

    @Override
    public UnderlyingEditorSettings getEditorSettings() {
        return this.editorSettings;
    }

    @Override
    public PlatformSpecificStateProvider getPlatformSpecificStateProvider() {
        return this.platformSpecificStateProvider;
    }

    @Override
    public SearchAndReplaceService getSearchAndReplaceService() {
        return this.searchAndReplaceService;
    }

    @Override
    public HighlightingService getHighlightingService() {
        return this.highlightingService;
    }

    @Override
    public void useGlobalRegisters() {
        this.registerManager = this.globalRegisterManager;
        this.swapMacroRecorder();
    }

    @Override
    public void useLocalRegisters() {
        this.registerManager = new DefaultRegisterManager();
        this.swapMacroRecorder();
    }

    @Override
    public LocalConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MacroRecorder getMacroRecorder() {
        return this.macroRecorder;
    }

    @Override
    public MacroPlayer getMacroPlayer(String macroName) throws CommandExecutionException {
        if (macroName == null || macroName.trim().isEmpty()) {
            throw new CommandExecutionException("Macro name is null or empty.");
        }
        if (this.macroStack.contains(macroName)) {
            this.recursionErrorMessage = "Macro @" + macroName + " is called recursively," + " macro execution aborted.";
            this.abortRecursion = true;
            throw new CommandExecutionException(this.recursionErrorMessage);
        }
        if (this.macroPlayer == null) {
            this.macroPlayer = new MacroPlayer(this, macroName);
        } else if (!this.macroPlayer.getMacroName().equals(macroName)) {
            throw new CommandExecutionException("Macro player mismatch: macro " + macroName + " requested when macro " + this.macroPlayer.getMacroName() + " is pending.");
        }
        return this.macroPlayer;
    }

    @Override
    public void stopMacrosAndMappings() {
        this.stopMacrosAndMappings(null);
    }

    @Override
    public void stopMacrosAndMappings(String errorMessage) {
        this.abortRecursion = true;
        this.recursionErrorMessage = errorMessage;
    }

    private void swapMacroRecorder() {
        if (this.macroRecorder.isRecording()) {
            this.macroRecorder.stopRecording();
        }
        this.macroRecorder = new MacroRecorder(this.registerManager, this.userInterfaceService);
    }

    /*
     * Unable to fully structure code
     */
    private boolean handleKey0(KeyStroke key) {
        block25: {
            block26: {
                block28: {
                    block27: {
                        block24: {
                            if (this.currentMode == null) break block25;
                            map = null;
                            keyMapName = this.currentMode.resolveKeyMap(key);
                            if (keyMapName != null) {
                                map = this.keyMapProvider.getKeyMap(keyMapName);
                            }
                            if (map == null || !(inMapping = this.keyStrokeTranslator.processKeyStroke(map, key))) break block26;
                            resultingKeyStrokes = this.keyStrokeTranslator.resultingKeyStrokes();
                            didMappingSucceed = this.keyStrokeTranslator.didMappingSucceed();
                            v0 = doBackTrack = didMappingSucceed == false && resultingKeyStrokes.size() > 1 && this.currentMode.isRemapBacktracking() != false;
                            if (this.currentMode instanceof InsertMode) {
                                if (this.cursorBeforeMapping == -1) {
                                    this.cursorBeforeMapping = this.cursorService.getPosition().getModelOffset();
                                }
                                if (resultingKeyStrokes.isEmpty()) {
                                    return this.currentMode.handleKey(key);
                                }
                                if (this.cursorService.getPosition().getModelOffset() - this.cursorBeforeMapping > 0) {
                                    try {
                                        if (didMappingSucceed || doBackTrack) {
                                            pendingChars = this.cursorService.getPosition().getModelOffset() - this.cursorBeforeMapping;
                                            i = 0;
                                            while (i < pendingChars) {
                                                this.currentMode.handleKey(new RemappedKeyStroke(new SimpleKeyStroke(SpecialKey.BACKSPACE), false));
                                                ++i;
                                            }
                                            break block24;
                                        }
                                        if (KeyMap.GLOBAL_MAP.containsKey(key)) {
                                            key = new RemappedKeyStroke(KeyMap.GLOBAL_MAP.get(key), false);
                                        }
                                        var11_14 = this.currentMode.handleKey(key);
                                        return var11_14;
                                    }
                                    finally {
                                        this.cursorBeforeMapping = -1;
                                    }
                                }
                                this.cursorBeforeMapping = -1;
                            } else if (resultingKeyStrokes.isEmpty()) {
                                this.currentMode.addKeyToMapBuffer(key);
                            } else {
                                this.currentMode.cleanMapBuffer(didMappingSucceed);
                            }
                        }
                        if (!doBackTrack) break block27;
                        this.currentMode.handleKey(resultingKeyStrokes.poll());
                        while (!resultingKeyStrokes.isEmpty()) {
                            next = resultingKeyStrokes.poll();
                            this.handleKeyOffRecord(next);
                        }
                        break block28;
                    }
                    if (!didMappingSucceed) ** GOTO lbl66
                    mappingId = String.valueOf('[') + map.getMapId() + "] " + ConstructorWrappers.keyStrokesToString(this.keyStrokeTranslator.originalKeyStrokes());
                    if (this.mappingStack.contains(mappingId)) {
                        this.recursionErrorMessage = "Mapping " + mappingId + " is called " + "recursively, mapping execution aborted.";
                        this.abortRecursion = true;
                        return true;
                    }
                    this.mappingStack.push(mappingId);
                    try {
                        if (true) ** GOTO lbl66
                        do {
                            if ((next = resultingKeyStrokes.poll()).isRecursive()) {
                                this.handleKeyOffRecord(next);
                            } else {
                                this.currentMode.handleKey(next);
                            }
lbl66:
                            // 4 sources

                            if (resultingKeyStrokes.isEmpty()) break;
                        } while (!this.abortRecursion);
                    }
                    finally {
                        if (didMappingSucceed && !this.mappingStack.isEmpty()) {
                            this.mappingStack.pop();
                        }
                    }
                }
                return true;
            }
            if (KeyMap.GLOBAL_MAP.containsKey(key)) {
                key = new RemappedKeyStroke(KeyMap.GLOBAL_MAP.get(key), false);
            }
            return this.currentMode.handleKey(key);
        }
        return false;
    }

    @Override
    public void onChangeEnabled(boolean enabled) {
        if (enabled) {
            Selection eclipseSelection = this.getSelection();
            if (eclipseSelection.getModelLength() > 0) {
                this.rememberLastActiveSelection();
                this.changeModeSafely("visual mode", VisualMode.RECALL_SELECTION_HINT);
            } else {
                this.changeModeSafely("normal mode", InsertMode.DONT_MOVE_CURSOR);
            }
        } else {
            this.changeModeSafely("insert mode", InsertMode.DONT_MOVE_CURSOR, InsertMode.DONT_LOCK_HISTORY);
            this.userInterfaceService.setEditorMode("vrapper disabled");
        }
        this.listeners.fireVrapperToggled(enabled);
    }

    @Override
    public void rememberLastActiveSelection() {
        Selection selection = this.selectionService.getSelection();
        if (selection.getRightBound().getModelOffset() > this.getModelContent().getTextLength()) {
            VrapperLog.info("Selection was outside of bounds of document. Fixing...");
            selection = selection.reset(this, selection.getFrom(), selection.getTo());
        }
        this.registerManager.setLastActiveSelection(SelectionArea.getInstance(this, selection));
        this.cursorService.setMark("<", selection.getStartMark(this));
        this.cursorService.setMark(">", selection.getEndMark(this));
        this.cursorService.setMark("x-vrapper-sel-from", selection.getFrom());
        this.cursorService.setMark("x-vrapper-sel-to", selection.getTo());
        this.lastSelection = selection;
    }

    @Override
    public SelectionArea getLastActiveSelectionArea() {
        return this.registerManager.getLastActiveSelectionArea();
    }

    @Override
    public Selection getLastActiveSelection() {
        return this.lastSelection;
    }

    @Override
    public SearchResult getLastSearchResult() {
        return this.searchResult;
    }

    @Override
    public void setLastSearchResult(SearchResult result) {
        this.searchResult = result;
    }

    @Override
    public String getCurrentModeName() {
        return this.currentMode != null ? this.currentMode.getName() : null;
    }

    @Override
    public EditorMode getCurrentMode() {
        return this.currentMode;
    }

    @Override
    public String getEditorType() {
        return this.editorType;
    }

    @Override
    public void addVrapperEventListener(VrapperEventListener listener) {
        this.listeners.addEventListener(listener);
    }

    @Override
    public void removeVrapperEventListener(VrapperEventListener listener) {
        this.listeners.removeEventListener(listener);
    }

    @Override
    public VrapperEventListeners getListeners() {
        return this.listeners;
    }

    @Override
    public CommandLineUI getCommandLine() {
        return this.userInterfaceService.getCommandLineUI(this);
    }
}

