/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.vim.SimpleKeyStroke;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.SearchAndReplaceService;
import net.sourceforge.vrapper.platform.SimpleConfiguration;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchResult;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.Utils;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class VimUtils {
    public static final Pattern COMPILED_PATTERN_DELIM_PATTERN = Pattern.compile("[^A-Za-z0-9]");
    public static int BREAKPOINT_TRIGGER = 0;

    private VimUtils() {
    }

    public static boolean isWhiteSpace(String s) {
        return VimConstants.WHITESPACE.contains(s);
    }

    public static int getFirstNonWhiteSpaceOffset(TextContent content, LineInformation line) {
        int index = line.getBeginOffset();
        int end = line.getEndOffset();
        while (index < end) {
            String s = content.getText(index, 1);
            if (!VimUtils.isWhiteSpace(s)) break;
            ++index;
        }
        return index;
    }

    public static int getLastNonWhiteSpaceOffset(TextContent content, LineInformation line) {
        if (line.getLength() == 0) {
            return line.getBeginOffset();
        }
        int index = line.getEndOffset() - 1;
        int begin = line.getBeginOffset();
        while (index > begin) {
            String s = content.getText(index, 1);
            if (!VimUtils.isWhiteSpace(s)) break;
            --index;
        }
        return index;
    }

    public static String getIndent(TextContent content, LineInformation line) {
        int offset = VimUtils.getFirstNonWhiteSpaceOffset(content, line);
        return content.getText(line.getBeginOffset(), offset - line.getBeginOffset());
    }

    public static String getWithoutIndent(TextContent content, LineInformation info) {
        int offset = VimUtils.getFirstNonWhiteSpaceOffset(content, info);
        return content.getText(offset, info.getEndOffset() - offset);
    }

    public static String getWordUnderCursor(EditorAdaptor editorAdaptor, boolean wholeWord) {
        String s;
        String keywords;
        String word = "";
        TextContent p = editorAdaptor.getViewContent();
        int index = editorAdaptor.getCursorService().getPosition().getViewOffset();
        LineInformation line = p.getLineInformationOfOffset(index);
        int min = line.getBeginOffset();
        int max = line.getEndOffset();
        int first = -1;
        int last = -1;
        boolean found = false;
        String string = keywords = wholeWord ? "\\S" : editorAdaptor.getConfiguration().get(Options.KEYWORDS);
        if (index < max && Utils.characterType((s = p.getText(index, 1)).charAt(0), keywords) == 1) {
            found = true;
            first = index;
            last = index;
        }
        while (index < max - 1) {
            if (Utils.characterType((s = p.getText(++index, 1)).charAt(0), keywords) == 1) {
                last = index;
                if (found) continue;
                first = index;
                found = true;
                continue;
            }
            if (found) break;
        }
        if (found) {
            index = first;
            while (index > min) {
                if (Utils.characterType((s = p.getText(--index, 1)).charAt(0), keywords) != 1) break;
                first = index;
            }
            word = p.getText(first, last - first + 1);
        }
        return word;
    }

    public static boolean containsNewLine(String s) {
        for (String newline : VimConstants.NEWLINE) {
            if (!s.contains(newline)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNewLine(String s) {
        return VimConstants.NEWLINE.contains(s);
    }

    public static int startsWithNewLine(String s) {
        int nlLen = 0;
        for (String newline : VimConstants.NEWLINE) {
            if (!s.startsWith(newline)) continue;
            nlLen = Math.max(nlLen, newline.length());
        }
        return nlLen;
    }

    public static int endsWithNewLine(String s) {
        int nlLen = 0;
        for (String newline : VimConstants.NEWLINE) {
            if (!s.endsWith(newline)) continue;
            nlLen = Math.max(nlLen, newline.length());
        }
        return nlLen;
    }

    public static String replaceNewLines(String inputString, String replacement) {
        char[] input = inputString.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < input.length) {
            if (input[i] == '\r' && i + 1 < input.length && input[i + 1] == '\n') {
                sb.append(replacement);
                ++i;
            } else if (input[i] == '\r') {
                sb.append(replacement);
            } else if (input[i] == '\n') {
                sb.append(replacement);
            } else {
                sb.append(input[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isPatternDelimiter(String s) {
        return COMPILED_PATTERN_DELIM_PATTERN.matcher(s).find();
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().equals("");
    }

    public static boolean isLineBlank(TextContent content, int lineNo) {
        LineInformation line = content.getLineInformation(lineNo);
        return VimUtils.isBlank(content.getText(line.getBeginOffset(), line.getLength()));
    }

    public static boolean endsWithEOL(EditorAdaptor editor) {
        TextContent content = editor.getModelContent();
        LineInformation line = content.getLineInformation(content.getNumberOfLines() - 1);
        return line.getNumber() > 0 && line.getLength() == 0;
    }

    public static int calculateColForPosition(TextContent p, Position position) {
        return VimUtils.calculateColForOffset(p, position.getModelOffset());
    }

    public static int calculateColForOffset(TextContent p, int modelOffset) {
        LineInformation line = p.getLineInformationOfOffset(modelOffset);
        return modelOffset - line.getBeginOffset();
    }

    public static int calculateLine(TextContent text, int offset) {
        LineInformation line = text.getLineInformationOfOffset(offset);
        return line.getNumber();
    }

    public static int calculateLine(TextContent text, Position position) {
        return VimUtils.calculateLine(text, position.getModelOffset());
    }

    public static int calculatePositionForOffset(TextContent p, int position, int offset) {
        block8: {
            LineInformation line;
            block9: {
                line = p.getLineInformationOfOffset(position);
                if (offset >= 0) break block9;
                int i = -offset;
                while (i > 0) {
                    if (position > line.getBeginOffset()) {
                        --position;
                    } else {
                        int nextLine = line.getNumber() - 1;
                        if (nextLine < 0) break block8;
                        line = p.getLineInformation(nextLine);
                        position = Math.max(line.getBeginOffset(), line.getEndOffset() - 1);
                    }
                    --i;
                }
                break block8;
            }
            if (offset <= 0) break block8;
            int i = offset;
            int end = Math.max(line.getBeginOffset(), line.getEndOffset() - 1);
            while (i > 0) {
                if (position < end) {
                    ++position;
                } else {
                    int nextLine = line.getNumber() + 1;
                    if (nextLine > p.getNumberOfLines() - 1) break;
                    line = p.getLineInformation(nextLine);
                    end = Math.max(line.getBeginOffset(), line.getEndOffset() - 1);
                    position = line.getBeginOffset();
                }
                --i;
            }
        }
        return position;
    }

    public static String stripLastNewline(String text) {
        if (text.endsWith(SimpleConfiguration.NewLine.WINDOWS.nl)) {
            return text.substring(0, text.length() - 2);
        }
        if (text.endsWith(SimpleConfiguration.NewLine.UNIX.nl) || text.endsWith(SimpleConfiguration.NewLine.MAC.nl)) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static final <T> Set<T> set(T ... content) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(content)));
    }

    public static final <T> List<T> list(T ... content) {
        return Collections.unmodifiableList(new ArrayList<T>(Arrays.asList(content)));
    }

    public static SearchResult wrapAroundSearch(EditorAdaptor vim, Search search, Position position) {
        SearchAndReplaceService searcher = vim.getSearchAndReplaceService();
        SearchResult result = searcher.find(search, position);
        if (!result.isFound() && vim.getConfiguration().get(Options.WRAP_SCAN).booleanValue()) {
            TextContent p = vim.getModelContent();
            int index = search.isBackward() ? p.getLineInformation(p.getNumberOfLines() - 1).getEndOffset() - 1 : 0;
            result = searcher.find(search, position.setModelOffset(index));
        }
        return result;
    }

    public static SearchResult wrapSelectionSearch(EditorAdaptor vim, Search search, Position position) {
        Position newStart;
        Selection selection = vim.getLastActiveSelection();
        position = search.isBackward() ? (selection.getRightBound().compareTo(position) > 0 ? position : selection.getRightBound()) : (selection.getLeftBound().compareTo(position) < 0 ? position : selection.getLeftBound());
        SearchAndReplaceService searcher = vim.getSearchAndReplaceService();
        SearchResult result = searcher.find(search, position);
        if (result.isFound() && (result.getLeftBound().compareTo(selection.getLeftBound()) < 0 || result.getRightBound().compareTo(selection.getRightBound()) > 0)) {
            result = new SearchResult(null, null);
        }
        if (!result.isFound() && vim.getConfiguration().get(Options.WRAP_SCAN).booleanValue() && (result = searcher.find(search, newStart = search.isBackward() ? selection.getRightBound() : selection.getLeftBound())).isFound() && (result.getLeftBound().compareTo(selection.getLeftBound()) < 0 || result.getRightBound().compareTo(selection.getRightBound()) > 0)) {
            result = new SearchResult(null, null);
        }
        return result;
    }

    public static Position fixLeftDelimiter(TextContent model, CursorService cursor, Position delim) {
        if (VimUtils.isNewLine(model.getText(delim.getModelOffset() + 1, 1))) {
            LineInformation line = model.getLineInformationOfOffset(delim.getModelOffset());
            LineInformation nextLine = model.getLineInformation(line.getNumber() + 1);
            delim = cursor.newPositionForModelOffset(nextLine.getBeginOffset());
        } else {
            delim = delim.addModelOffset(1);
        }
        return delim;
    }

    public static Position fixRightDelimiter(TextContent model, CursorService cursor, Position delim) {
        String text;
        LineInformation line;
        int lineStart;
        int delimIndex = delim.getModelOffset();
        if (delimIndex > (lineStart = (line = model.getLineInformationOfOffset(delimIndex)).getBeginOffset()) && VimUtils.isBlank(text = model.getText(lineStart, delimIndex - lineStart))) {
            LineInformation previousLine = model.getLineInformation(line.getNumber() - 1);
            delimIndex = previousLine.getEndOffset();
            delim = cursor.newPositionForModelOffset(delimIndex);
        }
        return delim;
    }

    public static KeyStroke fixAltGrKey(KeyStroke key) {
        if (!key.withAltKey()) {
            return null;
        }
        EnumSet<KeyStroke.Modifier> modifiers = EnumSet.copyOf(key.getModifiers());
        modifiers.remove((Object)KeyStroke.Modifier.ALT);
        modifiers.remove((Object)KeyStroke.Modifier.CONTROL);
        if (key.getSpecialKey() == null) {
            return new SimpleKeyStroke(key.getCharacter(), modifiers);
        }
        return new SimpleKeyStroke(key.getSpecialKey(), modifiers);
    }

    public static Position safeAddModelOffset(EditorAdaptor adaptor, Position original, int delta, boolean allowPastLastChar) {
        CursorService cursorService = adaptor.getCursorService();
        int originalPos = original.getModelOffset();
        return cursorService.shiftPositionForModelOffset(originalPos, delta, allowPastLastChar);
    }

    public static <T> T findModeHint(Class<T> typeToFind, ModeSwitchHint ... args) {
        ModeSwitchHint result = null;
        if (args.length >= 1 && typeToFind.isInstance(args[0])) {
            result = args[0];
        }
        int i = 1;
        while (i < args.length && result == null) {
            if (typeToFind.isInstance(args[i])) {
                result = args[i];
            }
            ++i;
        }
        return (T)result;
    }
}

