/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.FileService;
import net.sourceforge.vrapper.platform.Platform;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.platform.UserInterfaceService;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Space;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.ConfigurationListener;
import net.sourceforge.vrapper.vim.LocalConfiguration;
import net.sourceforge.vrapper.vim.Options;

public class UnmodifiableTextContentDecorator
implements TextContent {
    private TextContent textContent;
    private boolean modifiable = true;
    private UserInterfaceService uiService;
    private FileService fileService;

    public UnmodifiableTextContentDecorator(TextContent target, LocalConfiguration configuration, Platform platform) {
        this.textContent = target;
        this.uiService = platform.getUserInterfaceService();
        this.fileService = platform.getFileService();
        configuration.addListener(new ConfigurationListener(){

            @Override
            public <T> void optionChanged(Configuration.Option<T> option, T oldValue, T newValue) {
                if (option.equals(Options.MODIFIABLE)) {
                    UnmodifiableTextContentDecorator.this.modifiable = Boolean.TRUE.equals(newValue);
                }
            }
        });
    }

    @Override
    public LineInformation getLineInformation(int line) {
        return this.textContent.getLineInformation(line);
    }

    @Override
    public LineInformation getLineInformationOfOffset(int offset) {
        return this.textContent.getLineInformationOfOffset(offset);
    }

    @Override
    public int getNumberOfLines() {
        return this.textContent.getNumberOfLines();
    }

    @Override
    public void replace(int index, int length, String s) {
        if (this.allowChanges()) {
            this.textContent.replace(index, length, s);
        }
    }

    @Override
    public void smartInsert(int index, String s) {
        if (this.allowChanges()) {
            this.textContent.smartInsert(index, s);
        }
    }

    @Override
    public void smartInsert(String s) {
        if (this.allowChanges()) {
            this.textContent.smartInsert(s);
        }
    }

    @Override
    public String getText(int index, int length) {
        return this.textContent.getText(index, length);
    }

    @Override
    public String getText(TextRange range) {
        return this.textContent.getText(range);
    }

    @Override
    public int getTextLength() {
        return this.textContent.getTextLength();
    }

    @Override
    public Space getSpace() {
        return this.textContent.getSpace();
    }

    protected boolean allowChanges() {
        if (this.modifiable && this.fileService.isEditable() && this.fileService.checkModifiable()) {
            return true;
        }
        if (!this.fileService.isEditable()) {
            this.uiService.setErrorMessage("Cannot modify contents, file is not editable!");
        } else {
            this.uiService.setErrorMessage("Cannot modify contents, 'modifiable' is off!");
        }
        return false;
    }

    public String toString() {
        return "(UTD) {" + this.textContent.toString() + "}";
    }
}

