/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.vrapper.utils.ExplodedPattern;

public class StringUtils {
    public static String multiply(String str, int count) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < count) {
            builder.append(str);
            ++i;
        }
        return builder.toString();
    }

    public static String join(String separator, Object[] items) {
        return StringUtils.join(separator, Arrays.asList(items));
    }

    public static String join(String separator, Iterable<?> items) {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (Object item : items) {
            builder.append(sep);
            builder.append(item);
            sep = separator;
        }
        return builder.toString();
    }

    public static int countNewlines(String lines) {
        return lines.length() - lines.replace("\n", "").length();
    }

    public static boolean containsUppercase(String keyword) {
        int i = 0;
        while (i < keyword.length()) {
            if (Character.isUpperCase(keyword.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String repr(String str) {
        if (str == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder("\"");
        int i = 0;
        while (i < str.length()) {
            char chr = str.charAt(i);
            switch (chr) {
                case '\u0000': {
                    result.append("\\0");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\"': {
                    result.append("\\\"");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                default: {
                    result.append(StringUtils.isPrintableASCII(chr) ? Character.valueOf(chr) : String.format("\\u%04x", Character.valueOf(chr)));
                }
            }
            ++i;
        }
        return result.append('\"').toString();
    }

    public static boolean isPrintableASCII(char chr) {
        return ' ' <= chr && chr <= '~';
    }

    public static int[] calculateVisualOffsets(String contents, int maxIndex, int tabstop) {
        if (maxIndex > contents.length()) {
            maxIndex = contents.length();
        }
        int[] result = new int[maxIndex + 1];
        int nextTabstopOff = 0;
        int visualOffset = 0;
        int i = 0;
        while (i < maxIndex) {
            result[i] = visualOffset;
            if (visualOffset % tabstop == 0) {
                nextTabstopOff += tabstop;
            }
            if (contents.charAt(i) == '\t') {
                visualOffset = nextTabstopOff;
            } else if (!Character.isHighSurrogate(contents.charAt(i))) {
                ++visualOffset;
            }
            ++i;
        }
        result[i] = visualOffset;
        return result;
    }

    public static ExplodedPattern explodePattern(String pattern) throws IllegalArgumentException {
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (i < pattern.length()) {
            char currentChar = pattern.charAt(i);
            if (currentChar == '\\' && i + 1 == pattern.length()) {
                throw new IllegalArgumentException("Unmatched backslash found at end of pattern!");
            }
            if (currentChar == '\\') {
                char nextChar = pattern.charAt(i + 1);
                if (nextChar == '%' && i + 2 == pattern.length()) {
                    throw new IllegalArgumentException("Backslash-% without extra token found at end of pattern!");
                }
                if (nextChar == '%') {
                    parts.add(pattern.substring(i, i + 3));
                    i += 2;
                } else {
                    parts.add(pattern.substring(i, i + 2));
                    ++i;
                }
            } else {
                if (Character.isHighSurrogate(currentChar) && i + 1 == pattern.length()) {
                    throw new IllegalArgumentException("Unmatched surrogate found at end of pattern!");
                }
                if (Character.isHighSurrogate(currentChar)) {
                    parts.add(pattern.substring(i, i + 1));
                    ++i;
                } else {
                    parts.add(pattern.substring(i, i + 1));
                }
            }
            ++i;
        }
        return new ExplodedPattern(parts);
    }

    public static PatternHolder splitIntoPatterns(String pattern, int patternsToScan) throws IllegalArgumentException {
        PatternHolder result = new PatternHolder();
        char delimiter = result.delimiter = pattern.charAt(0);
        int i = 1;
        int currentPatternNum = 0;
        ArrayList<String> currentPattern = new ArrayList<String>();
        while (i < pattern.length() && currentPatternNum < patternsToScan) {
            char currentChar = pattern.charAt(i);
            if (currentChar == delimiter) {
                result.patterns.add(new ExplodedPattern(currentPattern));
                currentPattern.clear();
                ++currentPatternNum;
            } else {
                if (currentChar == '\\' && i + 1 == pattern.length()) {
                    throw new IllegalArgumentException("Unmatched backslash found at end of pattern!");
                }
                if (currentChar == '\\') {
                    char nextChar = pattern.charAt(i + 1);
                    if (nextChar == '%' && i + 2 == pattern.length()) {
                        throw new IllegalArgumentException("Backslash-% without extra token found at end of pattern!");
                    }
                    if (nextChar == '%') {
                        currentPattern.add(pattern.substring(i, i + 3));
                        i += 2;
                    } else {
                        currentPattern.add(pattern.substring(i, i + 2));
                        ++i;
                    }
                } else {
                    if (Character.isHighSurrogate(currentChar) && i + 1 == pattern.length()) {
                        throw new IllegalArgumentException("Unmatched surrogate found at end of pattern!");
                    }
                    if (Character.isHighSurrogate(currentChar)) {
                        currentPattern.add(pattern.substring(i, i + 1));
                        ++i;
                    } else {
                        currentPattern.add(pattern.substring(i, i + 1));
                    }
                }
            }
            ++i;
        }
        if (i < pattern.length() && currentPatternNum == patternsToScan) {
            result.remainder = pattern.substring(i);
        } else if (currentPatternNum < patternsToScan) {
            result.patterns.add(new ExplodedPattern(currentPattern));
            ++currentPatternNum;
        }
        return result;
    }

    public static class PatternHolder {
        public char delimiter;
        public List<ExplodedPattern> patterns = new ArrayList<ExplodedPattern>();
        public String remainder = "";
    }
}

