/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;

public class StartEndTextRange
implements TextRange {
    private final Position start;
    private final Position end;

    public StartEndTextRange(Position start, Position end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public Position getStart() {
        return this.start;
    }

    @Override
    public Position getEnd() {
        return this.end;
    }

    @Override
    public Position getLeftBound() {
        return !this.isReversed() ? this.getStart() : this.getEnd();
    }

    @Override
    public Position getRightBound() {
        return !this.isReversed() ? this.getEnd() : this.getStart();
    }

    @Override
    public int getModelLength() {
        return Math.abs(this.getSignedModelLength());
    }

    @Override
    public int getViewLength() {
        return Math.abs(this.getEnd().getViewOffset() - this.getStart().getViewOffset());
    }

    @Override
    public boolean isReversed() {
        return this.getSignedModelLength() < 0;
    }

    private int getSignedModelLength() {
        return this.getEnd().getModelOffset() - this.getStart().getModelOffset();
    }

    public static TextRange lines(EditorAdaptor editor, Position from, Position to) {
        int endOffset;
        int nextLineTolastLine;
        int firstLine;
        TextContent txt = editor.getModelContent();
        LineInformation sLine = txt.getLineInformationOfOffset(from.getModelOffset());
        LineInformation eLine = txt.getLineInformationOfOffset(to.getModelOffset());
        CursorService cs = editor.getCursorService();
        if (sLine.getNumber() > eLine.getNumber()) {
            firstLine = eLine.getNumber();
            nextLineTolastLine = sLine.getNumber() + 1;
        } else {
            firstLine = sLine.getNumber();
            nextLineTolastLine = eLine.getNumber() + 1;
        }
        int beginOffset = txt.getLineInformation(firstLine).getBeginOffset();
        if (nextLineTolastLine < txt.getNumberOfLines()) {
            endOffset = txt.getLineInformation(nextLineTolastLine).getBeginOffset();
        } else {
            endOffset = txt.getTextLength();
            if (firstLine == 0) {
                beginOffset = 0;
            }
        }
        if (sLine.getNumber() > eLine.getNumber()) {
            return new StartEndTextRange(cs.newPositionForModelOffset(endOffset), cs.newPositionForModelOffset(beginOffset));
        }
        return new StartEndTextRange(cs.newPositionForModelOffset(beginOffset), cs.newPositionForModelOffset(endOffset));
    }

    public String toString() {
        return "StartEndTextRange(M " + this.start.getModelOffset() + "/" + this.start.getViewOffset() + " V - M " + this.end.getModelOffset() + "/" + this.end.getViewOffset() + " V)";
    }

    public static TextRange exclusive(Position from, Position to) {
        return new StartEndTextRange(from, to);
    }

    public static TextRange inclusive(CursorService cursorService, Position from, Position to) {
        int toOffset;
        int fromOffset = from.getModelOffset();
        if (fromOffset <= (toOffset = to.getModelOffset())) {
            return new StartEndTextRange(from, cursorService.shiftPositionForModelOffset(toOffset, 1, true));
        }
        return new StartEndTextRange(cursorService.shiftPositionForModelOffset(fromOffset, 1, true), to);
    }
}

