/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SearchResult;
import net.sourceforge.vrapper.utils.VimUtils;

public abstract class SearchOffset {
    public static final SearchOffset NONE = new Begin(0);
    private final int offset;

    private SearchOffset(int offset) {
        this.offset = offset;
    }

    public abstract Position apply(TextContent var1, SearchResult var2);

    public abstract Position unapply(TextContent var1, Position var2, SearchResult var3);

    public abstract boolean lineWise();

    public int getOffset() {
        return this.offset;
    }

    /* synthetic */ SearchOffset(int n, SearchOffset searchOffset) {
        this(n);
    }

    public static class Begin
    extends SearchOffset {
        public Begin(int offset) {
            super(offset, null);
        }

        @Override
        public Position apply(TextContent modelContent, SearchResult result) {
            Position start = result.getLeftBound();
            return start.setModelOffset(VimUtils.calculatePositionForOffset(modelContent, start.getModelOffset(), this.getOffset()));
        }

        @Override
        public Position unapply(TextContent modelContent, Position position, SearchResult result) {
            return position.setModelOffset(VimUtils.calculatePositionForOffset(modelContent, position.getModelOffset(), -this.getOffset()));
        }

        @Override
        public boolean lineWise() {
            return false;
        }
    }

    public static class End
    extends SearchOffset {
        public End(int offset) {
            super(offset, null);
        }

        @Override
        public Position apply(TextContent modelContent, SearchResult result) {
            Position end = result.getRightBound();
            return end.setModelOffset(VimUtils.calculatePositionForOffset(modelContent, end.getModelOffset(), this.getOffset() - 1));
        }

        @Override
        public Position unapply(TextContent modelContent, Position position, SearchResult result) {
            return position.setModelOffset(VimUtils.calculatePositionForOffset(modelContent, position.getModelOffset(), -result.getModelLength() - this.getOffset() + 1));
        }

        @Override
        public boolean lineWise() {
            return false;
        }
    }

    public static class Line
    extends SearchOffset {
        public Line(int offset) {
            super(offset, null);
        }

        @Override
        public Position apply(TextContent modelContent, SearchResult result) {
            TextContent tc = modelContent;
            Position start = result.getLeftBound();
            LineInformation currLine = tc.getLineInformationOfOffset(start.getModelOffset());
            int number = currLine.getNumber() + this.getOffset();
            number = Math.max(number, 0);
            number = Math.min(number, tc.getNumberOfLines() - 1);
            return start.setModelOffset(tc.getLineInformation(number).getBeginOffset());
        }

        @Override
        public Position unapply(TextContent modelContent, Position position, SearchResult result) {
            return position;
        }

        @Override
        public boolean lineWise() {
            return true;
        }
    }
}

