/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.LineWiseSelection;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.motions.RangeSearchMotion;

public class LineAddressParser {
    public static Position parseAddressPosition(String range, EditorAdaptor editorAdaptor) {
        String lineDef;
        String modifierDef = "";
        char modifier = '\u0000';
        Pattern endsWithNumber = Pattern.compile("^\\D+?(\\d+)$");
        Matcher match = endsWithNumber.matcher(range);
        if (range.contains("+")) {
            modifier = '+';
            String[] pieces = range.split("\\+");
            lineDef = pieces[0];
            modifierDef = pieces[1];
        } else if (range.contains("-")) {
            modifier = '-';
            String[] pieces = range.split("-");
            lineDef = pieces[0];
            modifierDef = pieces[1];
        } else if (match.matches()) {
            modifier = '+';
            lineDef = range.substring(0, match.start(1));
            modifierDef = match.group(1);
        } else {
            lineDef = range;
        }
        Position pos = LineAddressParser.parseLineDefinition(lineDef, editorAdaptor);
        if (pos == null) {
            return null;
        }
        if (modifier != '\u0000') {
            pos = LineAddressParser.parseModifierDefinition(modifier, modifierDef, pos.getModelOffset(), editorAdaptor);
        }
        return pos;
    }

    private static Position parseLineDefinition(String lineDef, EditorAdaptor editorAdaptor) {
        Position pos;
        block24: {
            CursorService cursorService = editorAdaptor.getCursorService();
            TextContent modelContent = editorAdaptor.getModelContent();
            pos = null;
            if (lineDef.startsWith("'") && lineDef.length() > 1) {
                String mark = lineDef.substring(1);
                if (mark.equals("<")) {
                    try {
                        Selection selection = editorAdaptor.getSelection();
                        if (selection.getModelLength() == 0) {
                            pos = editorAdaptor.getCursorService().getMark("<");
                            break block24;
                        }
                        pos = editorAdaptor.getSelection().getRegion(editorAdaptor, 0).getLeftBound();
                    }
                    catch (CommandExecutionException commandExecutionException) {}
                } else if (mark.equals(">")) {
                    try {
                        Selection sel = editorAdaptor.getSelection();
                        if (sel.getModelLength() == 0) {
                            pos = editorAdaptor.getCursorService().getMark(">");
                        } else {
                            pos = editorAdaptor.getSelection().getRegion(editorAdaptor, 0).getRightBound();
                            if (sel instanceof LineWiseSelection) {
                                pos = pos.addModelOffset(-1);
                            }
                        }
                    }
                    catch (CommandExecutionException commandExecutionException) {}
                } else {
                    pos = cursorService.getMark(mark);
                }
            } else if (lineDef.startsWith("/") || lineDef.startsWith("?")) {
                pos = LineAddressParser.parseSearchPosition(lineDef, editorAdaptor);
            } else if (".".equals(lineDef) || lineDef.isEmpty()) {
                pos = cursorService.getPosition();
            } else if ("$".equals(lineDef)) {
                pos = cursorService.newPositionForModelOffset(modelContent.getTextLength() - 1);
            } else {
                int line;
                block25: {
                    try {
                        line = Integer.parseInt(lineDef);
                        if (line > 0) {
                            --line;
                        }
                        if (line <= modelContent.getNumberOfLines() - 1) break block25;
                        editorAdaptor.getUserInterfaceService().setErrorMessage("Invalid Range");
                        return null;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                pos = cursorService.newPositionForModelOffset(modelContent.getLineInformation(line).getBeginOffset());
            }
        }
        return pos;
    }

    private static Position parseSearchPosition(String searchDef, EditorAdaptor editorAdaptor) {
        Position start = editorAdaptor.getPosition();
        boolean reverse = searchDef.startsWith("?");
        String search = searchDef.substring(1, searchDef.length() - 1);
        try {
            Position pos = new RangeSearchMotion(search, start, reverse).destination(editorAdaptor);
            if (pos == null) {
                editorAdaptor.getUserInterfaceService().setErrorMessage("'" + search + "' not found");
            }
            return pos;
        }
        catch (CommandExecutionException commandExecutionException) {
            return null;
        }
    }

    private static Position parseModifierDefinition(char modifier, String modifierDef, int startOffset, EditorAdaptor editorAdaptor) {
        int modifierCount;
        CursorService cursorService = editorAdaptor.getCursorService();
        TextContent modelContent = editorAdaptor.getModelContent();
        try {
            modifierCount = Integer.parseInt(modifierDef);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        LineInformation startLine = modelContent.getLineInformationOfOffset(startOffset);
        int lineNumber = startLine.getNumber();
        lineNumber = modifier == '+' ? (lineNumber += modifierCount) : (lineNumber -= modifierCount);
        if (lineNumber < 0 || lineNumber > modelContent.getNumberOfLines() - 1) {
            editorAdaptor.getUserInterfaceService().setErrorMessage("Invalid Range");
            return null;
        }
        LineInformation newLine = modelContent.getLineInformation(lineNumber);
        return cursorService.newPositionForModelOffset(newLine.getBeginOffset());
    }
}

