/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExplodedPattern
implements Iterable<String> {
    protected List<String> contents;
    protected String cachedResult;

    public ExplodedPattern(List<String> contents) {
        this.contents = new ArrayList<String>(contents);
    }

    public StringBuilder appendTo(StringBuilder output) {
        if (this.cachedResult == null) {
            for (String charStr : this.contents) {
                output.append(charStr);
            }
        } else {
            output.append(this.cachedResult);
        }
        return output;
    }

    public String toString() {
        if (this.cachedResult == null) {
            StringBuilder output = new StringBuilder();
            for (String charStr : this.contents) {
                output.append(charStr);
            }
            this.cachedResult = output.toString();
        }
        return this.cachedResult;
    }

    public boolean containsUppercase() {
        for (String charStr : this.contents) {
            if (charStr.length() != 1 || !Character.isUpperCase(charStr.charAt(0))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String flagOrChar) {
        return this.contents.contains(flagOrChar);
    }

    public boolean replace(String flagOrChar, String target) {
        boolean result = false;
        if (target == null || target.length() == 0) {
            return this.removeAll(flagOrChar);
        }
        int i = 0;
        while (i < this.contents.size()) {
            if (this.contents.get(i).equals(flagOrChar)) {
                this.contents.set(i, target);
                result = true;
            }
            ++i;
        }
        this.cachedResult = null;
        return result;
    }

    public boolean removeAll(String flagOrChar) {
        boolean result = false;
        int i = 0;
        while (i < this.contents.size()) {
            if (this.contents.get(i).equals(flagOrChar)) {
                this.contents.remove(i);
                result = true;
                --i;
            }
            ++i;
        }
        this.cachedResult = null;
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        return this.contents.iterator();
    }
}

