/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.platform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.vrapper.platform.SimpleConfiguration;

public interface Configuration {
    public String getNewLine();

    public void setNewLine(String var1);

    public void setNewLine(SimpleConfiguration.NewLine var1);

    public <T> void set(Option<T> var1, T var2);

    public <T> T get(Option<T> var1);

    public <T> boolean isSet(Option<T> var1);

    public static class Option<T> {
        public static final String SET_DELIMITER = ",";
        public static final String SET_VALUE_ITEM = ":";
        private final String id;
        private final String[] alias;
        private final T defaultValue;
        private final List<String> allNames;
        private final Set<String> legalValues;
        private final OptionScope scope;

        private Option(String id, T defaultValue, Set<String> legalValues, String ... alias) {
            this(id, OptionScope.DEFAULT, defaultValue, legalValues, alias);
        }

        private Option(String id, OptionScope scope, T defaultValue, Set<String> legalValues, String ... alias) {
            this.id = id;
            this.defaultValue = defaultValue;
            this.legalValues = legalValues;
            this.alias = alias;
            this.allNames = new ArrayList<String>();
            this.allNames.add(id);
            this.allNames.addAll(Arrays.asList(alias));
            this.scope = scope;
        }

        public static final Option<Boolean> bool(String id, boolean defaultValue, String ... alias) {
            return new Option<Boolean>(id, defaultValue, null, alias);
        }

        public static final Option<Boolean> localBool(String id, boolean defaultValue, String ... alias) {
            return new Option<Boolean>(id, OptionScope.LOCAL, defaultValue, null, alias);
        }

        public static final Option<Boolean> globalBool(String id, boolean defaultValue, String ... alias) {
            return new Option<Boolean>(id, OptionScope.GLOBAL, defaultValue, null, alias);
        }

        public static final Option<String> string(String id, String defaultValue, String csv, String ... alias) {
            HashSet<String> legalValues = new HashSet<String>();
            String[] stringArray = csv.split(", *");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                legalValues.add(value);
                ++n2;
            }
            assert (legalValues.contains(defaultValue));
            return new Option<String>(id, defaultValue, legalValues, alias);
        }

        public static final Option<String> globalString(String id, String defaultValue, String csv, String ... alias) {
            HashSet<String> legalValues = new HashSet<String>();
            String[] stringArray = csv.split(", *");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                legalValues.add(value);
                ++n2;
            }
            assert (legalValues.contains(defaultValue));
            return new Option<String>(id, OptionScope.GLOBAL, defaultValue, legalValues, alias);
        }

        public static final Option<Set<String>> globalStringSet(String id, String defaultValueStr, String csv, String ... alias) {
            HashSet<String> legalValues = new HashSet<String>();
            String[] stringArray = csv.split(", *");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                legalValues.add(value);
                ++n2;
            }
            HashSet<String> defaultValues = new HashSet<String>();
            String[] stringArray2 = defaultValueStr.split(SET_DELIMITER);
            int n3 = stringArray2.length;
            n = 0;
            while (n < n3) {
                String value = stringArray2[n];
                if (value.length() > 0) {
                    int valueDelimIndex = value.indexOf(SET_VALUE_ITEM);
                    if (valueDelimIndex != -1) {
                        defaultValues.add(value.substring(0, valueDelimIndex + 1));
                    } else {
                        defaultValues.add(value);
                    }
                }
                ++n;
            }
            assert (legalValues.containsAll(defaultValues));
            return new Option<Set<String>>(id, OptionScope.GLOBAL, defaultValues, legalValues, alias);
        }

        public static final Option<String> globalStringNoConstraint(String id, String defaultValue, String ... alias) {
            return new Option<String>(id, OptionScope.GLOBAL, defaultValue, null, alias);
        }

        public static final Option<String> stringNoConstraint(String id, String defaultValue, String ... alias) {
            return new Option<String>(id, defaultValue, null, alias);
        }

        public static final Option<Integer> integer(String id, int defaultValue, String ... alias) {
            return new Option<Integer>(id, defaultValue, null, alias);
        }

        public String getId() {
            return this.id;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public String[] getAlias() {
            return this.alias;
        }

        public Iterable<String> getAllNames() {
            return this.allNames;
        }

        public Set<String> getLegalValues() {
            return this.legalValues;
        }

        public OptionScope getScope() {
            return this.scope;
        }

        public String toString() {
            return String.format("Option(%s)", this.id);
        }
    }

    public static enum OptionScope {
        LOCAL,
        GLOBAL,
        DEFAULT;

    }
}

