/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap.vim;

import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;

public class SimpleKeyStroke
implements KeyStroke {
    private final char character;
    private final SpecialKey specialKey;
    private final Set<KeyStroke.Modifier> modifiers;

    public SimpleKeyStroke(char character, Set<KeyStroke.Modifier> modifiers) {
        this.character = character;
        this.specialKey = null;
        this.modifiers = modifiers;
        if (modifiers == null) {
            throw new NullPointerException("Modifier Set cannot be null");
        }
    }

    public SimpleKeyStroke(SpecialKey key, Set<KeyStroke.Modifier> modifiers) {
        this.character = '\u0000';
        this.specialKey = key;
        this.modifiers = modifiers;
        if (modifiers == null) {
            throw new NullPointerException("Modifier Set cannot be null");
        }
    }

    public SimpleKeyStroke(char character) {
        this.character = character;
        this.specialKey = null;
        this.modifiers = EnumSet.noneOf(KeyStroke.Modifier.class);
    }

    public SimpleKeyStroke(SpecialKey key) {
        this.character = '\u0000';
        this.specialKey = key;
        this.modifiers = EnumSet.noneOf(KeyStroke.Modifier.class);
    }

    public SimpleKeyStroke(KeyStroke source, EnumSet<KeyStroke.Modifier> modifiers) {
        if (source.getSpecialKey() == null) {
            this.specialKey = null;
            this.character = source.getCharacter();
        } else {
            this.character = '\u0000';
            this.specialKey = source.getSpecialKey();
        }
        this.modifiers = modifiers;
        if (modifiers == null) {
            throw new NullPointerException("Modifier Set cannot be null");
        }
    }

    @Override
    public char getCharacter() {
        return this.character;
    }

    @Override
    public SpecialKey getSpecialKey() {
        return this.specialKey;
    }

    @Override
    public boolean withShiftKey() {
        return this.modifiers.contains((Object)KeyStroke.Modifier.SHIFT);
    }

    @Override
    public boolean withAltKey() {
        return this.modifiers.contains((Object)KeyStroke.Modifier.ALT);
    }

    @Override
    public boolean withCtrlKey() {
        return this.modifiers.contains((Object)KeyStroke.Modifier.CONTROL);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.character;
        result = 31 * result + (this.specialKey == null ? 0 : this.specialKey.hashCode());
        result = 31 * result + Boolean.valueOf(this.withCtrlKey()).hashCode();
        result = 31 * result + Boolean.valueOf(this.withAltKey()).hashCode();
        return result;
    }

    public String toString() {
        String key = this.specialKey == null ? Character.toString(this.character) : this.specialKey.toString();
        EnumSet<KeyStroke.Modifier> modifiers = EnumSet.copyOf(this.modifiers);
        modifiers.remove((Object)KeyStroke.Modifier.SHIFT);
        if ((this.specialKey != null || this.character == ' ') && this.withShiftKey()) {
            key = "S-" + key;
        }
        for (KeyStroke.Modifier modifier : modifiers) {
            key = String.valueOf(modifier.getShortId()) + key;
        }
        return "Key(" + key + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyStroke)) {
            return false;
        }
        KeyStroke other = (KeyStroke)obj;
        EnumSet<KeyStroke.Modifier> modifiers = EnumSet.copyOf(this.modifiers);
        modifiers.remove((Object)KeyStroke.Modifier.SHIFT);
        EnumSet<KeyStroke.Modifier> otherModifiers = EnumSet.copyOf(other.getModifiers());
        otherModifiers.remove((Object)KeyStroke.Modifier.SHIFT);
        if (this.character != other.getCharacter()) {
            return false;
        }
        if (this.specialKey != other.getSpecialKey()) {
            return false;
        }
        if (!modifiers.equals(otherModifiers)) {
            return false;
        }
        return this.specialKey == null && this.character != ' ' || this.withShiftKey() == other.withShiftKey();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public Set<KeyStroke.Modifier> getModifiers() {
        return this.modifiers;
    }
}

