/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap.vim;

import java.util.Set;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SimpleTransition;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.UnionState;
import net.sourceforge.vrapper.utils.Function;

public class KeyStrokeConvertingState<T>
implements State<T> {
    private final Function<T, KeyStroke> converter;
    private final Set<KeyStroke> supportedKeys;

    public KeyStrokeConvertingState(Function<T, KeyStroke> converter) {
        this(converter, null);
    }

    public KeyStrokeConvertingState(Function<T, KeyStroke> converter, Set<KeyStroke> supportedKeys) {
        this.converter = converter;
        this.supportedKeys = supportedKeys;
    }

    @Override
    public Transition<T> press(KeyStroke key) {
        if (this.supportedKeys == null || this.supportedKeys.contains(key)) {
            return new SimpleTransition<T>(this.converter.call(key));
        }
        return null;
    }

    @Override
    public State<T> union(State<T> other) {
        return new UnionState<T>(this, other);
    }

    public String stateIdentifier() {
        return this.getClass().getCanonicalName();
    }
}

