/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap.vim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.vrapper.keymap.CovariantState;
import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.HashMapState;
import net.sourceforge.vrapper.keymap.KeyBinding;
import net.sourceforge.vrapper.keymap.KeyMapInfo;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SimpleKeyBinding;
import net.sourceforge.vrapper.keymap.SimpleTransition;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.vim.CountConsumingKeyMapState;
import net.sourceforge.vrapper.keymap.vim.CountingState;
import net.sourceforge.vrapper.keymap.vim.KeyStrokeConvertingState;
import net.sourceforge.vrapper.keymap.vim.OperatorCommandState;
import net.sourceforge.vrapper.keymap.vim.PlugKeyStroke;
import net.sourceforge.vrapper.keymap.vim.SimpleKeyStroke;
import net.sourceforge.vrapper.keymap.vim.TextObjectState;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.Function;
import net.sourceforge.vrapper.vim.PerformOperationOnSearchResultCommand;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.ChangeCaretShapeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeModeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToSearchModeCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.Counted;
import net.sourceforge.vrapper.vim.commands.MotionTextObject;
import net.sourceforge.vrapper.vim.commands.SelectionBasedTextObjectCommand;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.TextOperationTextObjectCommand;
import net.sourceforge.vrapper.vim.commands.motions.LineEndMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.SearchResultMotion;
import net.sourceforge.vrapper.vim.modes.KeyMapResolver;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class ConstructorWrappers {
    private static final Map<String, KeyStroke> keyNames = ConstructorWrappers.createKeyMap();
    static final Map<SpecialKey, String> specialKeyNames = Collections.unmodifiableMap(new HashMap<SpecialKey, String>(){
        {
            SpecialKey[] specialKeyArray = SpecialKey.values();
            int n = specialKeyArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpecialKey key = specialKeyArray[n2];
                String keyName = key.toString();
                this.put(key, keyName);
                ++n2;
            }
            this.put(SpecialKey.ARROW_LEFT, "LEFT");
            this.put(SpecialKey.ARROW_RIGHT, "RIGHT");
            this.put(SpecialKey.ARROW_UP, "UP");
            this.put(SpecialKey.ARROW_DOWN, "DOWN");
        }
    });

    public static Iterable<KeyStroke> parseKeyStrokes(String s) {
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        int i = 0;
        while (i < s.length()) {
            char input = s.charAt(i);
            if (input == '<') {
                StringBuilder sb = new StringBuilder();
                if (i + 1 < s.length()) {
                    sb.append('<');
                    input = s.charAt(++i);
                }
                while (i < s.length() && input != '>' && ConstructorWrappers.isSpecialKeyChar(input)) {
                    sb.append(input);
                    if (++i >= s.length()) continue;
                    input = s.charAt(i);
                }
                if (input == '>' && sb.length() > 1) {
                    KeyStroke stroke = null;
                    String key = sb.substring(1).toUpperCase();
                    if (key.length() > 0 && key.equals("PLUG")) {
                        if (!s.substring(i + 1).startsWith("(")) {
                            VrapperLog.info("Bad <Plug> found, plug not followed by '(' in mapping '" + s + "' !");
                            break;
                        }
                        int terminator = s.indexOf(41, i);
                        if (terminator == -1) {
                            VrapperLog.info("Bad <Plug> found, could not locate end ')' in mapping '" + s + "' !");
                            break;
                        }
                        result.add(new PlugKeyStroke(s.substring(i + 1, terminator + 1)));
                        i = terminator;
                    } else {
                        if (key.length() > 0) {
                            stroke = ConstructorWrappers.parseSpecialKey(key);
                        }
                        if (stroke == null) {
                            VrapperLog.info("Key code <" + key + "> in mapping '" + s + "' is unknown." + " Ignoring.");
                        } else {
                            result.add(stroke);
                        }
                    }
                } else {
                    char[] cArray = sb.toString().toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        result.add(ConstructorWrappers.key(c));
                        ++n2;
                    }
                    if (i + 1 < s.length() && input == '<') {
                        --i;
                    } else if (!ConstructorWrappers.isSpecialKeyChar(input)) {
                        result.add(ConstructorWrappers.key(input));
                    }
                }
            } else {
                result.add(ConstructorWrappers.key(input));
            }
            ++i;
        }
        return result;
    }

    private static boolean isSpecialKeyChar(char c) {
        return Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '/' || c == '@' || c == ']' || c == '[' || c == '\\' || c == '^' || c == '=';
    }

    private static KeyStroke parseSpecialKey(String key) {
        KeyStroke stroke = null;
        if (key.length() > 20 || key.length() == 0) {
            return null;
        }
        if (key.startsWith("S-")) {
            KeyStroke k = ConstructorWrappers.parseSpecialKey(key.substring(2));
            if (k != null) {
                EnumSet<KeyStroke.Modifier> modifiers = EnumSet.copyOf(k.getModifiers());
                modifiers.add(KeyStroke.Modifier.SHIFT);
                stroke = k.getSpecialKey() == null && !k.withCtrlKey() && k.getCharacter() > ' ' ? new SimpleKeyStroke(Character.toUpperCase(k.getCharacter()), modifiers) : new SimpleKeyStroke(k, modifiers);
            }
        } else if (key.startsWith("A-") || key.startsWith("M-")) {
            KeyStroke k = ConstructorWrappers.parseSpecialKey(key.substring(2));
            if (k != null) {
                EnumSet<KeyStroke.Modifier> modifiers = EnumSet.copyOf(k.getModifiers());
                modifiers.add(KeyStroke.Modifier.ALT);
                stroke = new SimpleKeyStroke(k, modifiers);
            }
        } else if (key.startsWith("C-")) {
            KeyStroke k = ConstructorWrappers.parseSpecialKey(key.substring(2));
            if (k != null) {
                EnumSet<KeyStroke.Modifier> modifiers = EnumSet.copyOf(k.getModifiers());
                modifiers.add(KeyStroke.Modifier.CONTROL);
                stroke = new SimpleKeyStroke(k, modifiers);
            }
        } else if (key.startsWith("D-")) {
            KeyStroke k = ConstructorWrappers.parseSpecialKey(key.substring(2));
            if (k != null) {
                EnumSet<KeyStroke.Modifier> modifiers = EnumSet.copyOf(k.getModifiers());
                modifiers.add(KeyStroke.Modifier.COMMAND);
                stroke = new SimpleKeyStroke(k, modifiers);
            }
        } else if (keyNames.containsKey(key)) {
            stroke = keyNames.get(key);
        } else if (key.length() == 1 && key.charAt(0) >= ' ') {
            stroke = new SimpleKeyStroke(key.toLowerCase().charAt(0));
        }
        return stroke;
    }

    public static <T extends KeyStroke> String keyStrokesToString(Iterable<T> strokes) {
        StringBuilder sb = new StringBuilder();
        for (KeyStroke stroke : strokes) {
            sb.append(ConstructorWrappers.keyStrokeToString(stroke));
        }
        return sb.toString();
    }

    public static String keyStrokeToString(KeyStroke stroke) {
        StringBuilder keyName = new StringBuilder();
        boolean suppressAngleBrackets = false;
        if (stroke instanceof PlugKeyStroke) {
            PlugKeyStroke plug = (PlugKeyStroke)stroke;
            keyName.append("<Plug>").append(plug.getId());
            suppressAngleBrackets = true;
        } else if (stroke.getSpecialKey() == null) {
            if (stroke.getCharacter() == '<') {
                keyName.append("LT");
            } else if (stroke.getCharacter() == '>') {
                keyName.append("GT");
            } else if (stroke.getCharacter() == ' ') {
                keyName.append("SPACE");
            } else {
                keyName.append(stroke.getCharacter());
                suppressAngleBrackets = true;
            }
        } else {
            keyName.append(specialKeyNames.get((Object)stroke.getSpecialKey()));
        }
        if ((stroke.getSpecialKey() != null || stroke.getCharacter() == ' ') && stroke.withShiftKey()) {
            keyName.insert(0, "S-");
            suppressAngleBrackets = false;
        }
        EnumSet<KeyStroke.Modifier> modifiers = EnumSet.copyOf(stroke.getModifiers());
        modifiers.remove((Object)KeyStroke.Modifier.SHIFT);
        for (KeyStroke.Modifier modifier : modifiers) {
            keyName.insert(0, modifier.getShortId());
            suppressAngleBrackets = false;
        }
        if (!suppressAngleBrackets) {
            keyName.insert(0, '<').append('>');
        }
        return keyName.toString();
    }

    public static KeyStroke key(char key) {
        return new SimpleKeyStroke(key);
    }

    public static KeyStroke ctrlKey(char key) {
        return new SimpleKeyStroke(Character.toLowerCase(key), EnumSet.of(KeyStroke.Modifier.CONTROL));
    }

    public static KeyStroke ctrlKey(SpecialKey key) {
        return new SimpleKeyStroke(key, EnumSet.of(KeyStroke.Modifier.CONTROL));
    }

    public static KeyStroke key(SpecialKey key) {
        return new SimpleKeyStroke(key);
    }

    public static KeyStroke shiftKey(SpecialKey key) {
        return new SimpleKeyStroke(key, EnumSet.of(KeyStroke.Modifier.SHIFT));
    }

    public static <T> KeyBinding<T> binding(char k, Transition<T> transition) {
        return new SimpleKeyBinding<T>(ConstructorWrappers.key(k), transition);
    }

    public static <T> KeyBinding<T> binding(SpecialKey k, Transition<T> transition) {
        return new SimpleKeyBinding<T>(ConstructorWrappers.key(k), transition);
    }

    public static <T> KeyBinding<T> binding(KeyStroke stroke, Transition<T> transition) {
        return new SimpleKeyBinding<T>(stroke, transition);
    }

    public static <T> Transition<T> leaf(T value) {
        return new SimpleTransition<T>(value);
    }

    public static <T> Transition<T> transition(State<T> state) {
        return new SimpleTransition<T>(state);
    }

    public static <T> Transition<T> transition(T value, State<T> state) {
        return new SimpleTransition<T>(value, state);
    }

    public static <T> State<T> state(KeyBinding<T> ... bindings) {
        return new HashMapState<T>(Arrays.asList(bindings));
    }

    public static <T> KeyBinding<T> leafBind(KeyStroke k, T value) {
        return ConstructorWrappers.binding(k, ConstructorWrappers.leaf(value));
    }

    public static <T> KeyBinding<T> leafBind(char k, T value) {
        return ConstructorWrappers.binding(k, ConstructorWrappers.leaf(value));
    }

    public static <T> KeyBinding<T> leafBind(SpecialKey k, T value) {
        return ConstructorWrappers.binding(k, ConstructorWrappers.leaf(value));
    }

    public static <T> KeyBinding<T> leafCtrlBind(char k, T value) {
        return ConstructorWrappers.binding(ConstructorWrappers.ctrlKey(k), ConstructorWrappers.leaf(value));
    }

    public static <T> KeyBinding<T> leafCtrlBind(SpecialKey k, T value) {
        return ConstructorWrappers.binding(ConstructorWrappers.ctrlKey(k), ConstructorWrappers.leaf(value));
    }

    public static <T> KeyBinding<T> transitionBind(char k, State<T> state) {
        return ConstructorWrappers.binding(k, ConstructorWrappers.transition(state));
    }

    public static <T> KeyBinding<T> transitionBind(KeyStroke k, State<T> state) {
        return ConstructorWrappers.binding(k, ConstructorWrappers.transition(state));
    }

    public static <T> KeyBinding<T> transitionBind(char k, T value, State<T> state) {
        return ConstructorWrappers.binding(k, ConstructorWrappers.transition(value, state));
    }

    public static <T> KeyBinding<T> transitionBind(char k, KeyBinding<T> ... bindings) {
        return ConstructorWrappers.binding(k, ConstructorWrappers.transition(ConstructorWrappers.state(bindings)));
    }

    public static <T> KeyBinding<T> transitionBind(KeyStroke k, KeyBinding<T> ... bindings) {
        return ConstructorWrappers.binding(k, ConstructorWrappers.transition(ConstructorWrappers.state(bindings)));
    }

    public static <T> State<T> leafState(char k, T value) {
        return ConstructorWrappers.state(ConstructorWrappers.leafBind(k, value));
    }

    public static <T> State<T> leafState(KeyStroke k, T value) {
        return ConstructorWrappers.state(ConstructorWrappers.leafBind(k, value));
    }

    public static <T> State<T> transitionState(char k, State<T> state) {
        return ConstructorWrappers.state(ConstructorWrappers.transitionBind(k, state));
    }

    public static <T> State<T> transitionState(KeyStroke k, State<T> state) {
        return ConstructorWrappers.state(ConstructorWrappers.transitionBind(k, state));
    }

    public static SelectionBasedTextObjectCommand operatorMoveCmd(Command operator, Motion move) {
        return new SelectionBasedTextObjectCommand(operator, new MotionTextObject(move));
    }

    public static <T extends Counted<T>> State<T> counted(State<T> wrapped) {
        return CountingState.wrap(wrapped);
    }

    public static ChangeCaretShapeCommand changeCaret(CaretType caret) {
        return ChangeCaretShapeCommand.getInstance(caret);
    }

    public static KeyBinding<KeyMapInfo> operatorKeyMap(char key) {
        KeyMapInfo operatorInfo = new KeyMapInfo(KeyMapResolver.OMAP_NAME, "operator");
        State<KeyMapInfo> empty = EmptyState.getInstance();
        CountConsumingKeyMapState counteater = new CountConsumingKeyMapState(KeyMapResolver.OMAP_NAME, "operandcount", empty);
        return ConstructorWrappers.transitionBind(key, operatorInfo, counteater);
    }

    public static State<KeyMapInfo> prefixedOperatorKeyMap(char key1, char key2) {
        KeyMapInfo operatorInfo = new KeyMapInfo(KeyMapResolver.OMAP_NAME, "operator");
        State<KeyMapInfo> empty = EmptyState.getInstance();
        CountConsumingKeyMapState counteater = new CountConsumingKeyMapState(KeyMapResolver.OMAP_NAME, "operandcount", empty);
        return ConstructorWrappers.transitionState(key1, ConstructorWrappers.state(ConstructorWrappers.transitionBind(key2, operatorInfo, counteater)));
    }

    private static State<Command> operatorPendingState(char key, State<Command> operatorCommand) {
        return ConstructorWrappers.state(ConstructorWrappers.binding(key, ConstructorWrappers.transition(ConstructorWrappers.changeCaret(CaretType.HALF_RECT), operatorCommand)));
    }

    private static State<TextObject> operatorTextObjects(char doublekey, State<TextObject> textObjects) {
        LineEndMotion lineEndMotion = new LineEndMotion(BorderPolicy.LINE_WISE);
        TextObjectState toEOL = new TextObjectState(ConstructorWrappers.leafState(doublekey, lineEndMotion));
        return StateUtils.union(ConstructorWrappers.counted(toEOL), textObjects);
    }

    private static State<TextObject> prefixedOperatorTextObjects(char key1, char key2, State<TextObject> textObjects) {
        LineEndMotion lineEndMotion = new LineEndMotion(BorderPolicy.LINE_WISE);
        TextObjectState toEOL = new TextObjectState(ConstructorWrappers.leafState(key2, lineEndMotion));
        return StateUtils.union(ConstructorWrappers.counted(StateUtils.union(toEOL, ConstructorWrappers.transitionState(key1, toEOL))), textObjects);
    }

    public static State<Command> operatorCmdsWithUpperCase(char key, TextOperation command, TextObject eolMotion, State<TextObject> textObjects) {
        assert (Character.isLowerCase(key));
        TextOperationTextObjectCommand doToEOL = new TextOperationTextObjectCommand(command, eolMotion);
        return StateUtils.union(ConstructorWrappers.leafState(Character.toUpperCase(key), doToEOL), ConstructorWrappers.operatorCmds(key, command, textObjects));
    }

    public static State<Command> operatorCmds(char key, TextOperation command, State<TextObject> textObjects) {
        State<Command> operatorCmds = StateUtils.union(ConstructorWrappers.leafState('/', new ChangeToSearchModeCommand(false, new PerformOperationOnSearchResultCommand(command, SearchResultMotion.REPEAT))), ConstructorWrappers.leafState('?', new ChangeToSearchModeCommand(true, new PerformOperationOnSearchResultCommand(command, SearchResultMotion.REPEAT))), ConstructorWrappers.leafState(':', new ChangeModeCommand("command mode", new ModeSwitchHint[0])), new OperatorCommandState(command, ConstructorWrappers.operatorTextObjects(key, textObjects)));
        return ConstructorWrappers.operatorPendingState(key, operatorCmds);
    }

    public static State<Command> operatorCmds(char key, Command operator, State<TextObject> textObjects) {
        OperatorCommandState operatorCmds = new OperatorCommandState(operator, ConstructorWrappers.operatorTextObjects(key, textObjects));
        return ConstructorWrappers.operatorPendingState(key, operatorCmds);
    }

    public static State<Command> prefixedOperatorCmds(char prefix, char key, TextOperation command, State<TextObject> textObjects) {
        OperatorCommandState operatorCmds = new OperatorCommandState(command, ConstructorWrappers.prefixedOperatorTextObjects(prefix, key, textObjects));
        return ConstructorWrappers.transitionState(prefix, ConstructorWrappers.operatorPendingState(key, operatorCmds));
    }

    public static State<Command> prefixedOperatorCmds(char prefix, char key, Command operator, State<TextObject> textObjects) {
        OperatorCommandState operatorCmds = new OperatorCommandState(operator, ConstructorWrappers.prefixedOperatorTextObjects(prefix, key, textObjects));
        return ConstructorWrappers.transitionState(prefix, ConstructorWrappers.operatorPendingState(key, operatorCmds));
    }

    public static <T> State<T> convertKeyStroke(Function<T, KeyStroke> converter, Set<KeyStroke> keystrokes) {
        return new KeyStrokeConvertingState<T>(converter, keystrokes);
    }

    public static <T1, T2 extends T1> State<T1> covariant(State<T2> wrapped) {
        return new CovariantState(wrapped);
    }

    private static Map<String, KeyStroke> createKeyMap() {
        HashMap<String, KeyStroke> map = new HashMap<String, KeyStroke>();
        SpecialKey[] specialKeyArray = SpecialKey.values();
        int n = specialKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpecialKey key = specialKeyArray[n2];
            map.put(key.name().toUpperCase(), ConstructorWrappers.key(key));
            ++n2;
        }
        map.put("DEL", ConstructorWrappers.key(SpecialKey.DELETE));
        map.put("INS", ConstructorWrappers.key(SpecialKey.INSERT));
        map.put("BS", ConstructorWrappers.key(SpecialKey.BACKSPACE));
        map.put("RETURN", ConstructorWrappers.key(SpecialKey.RETURN));
        map.put("ENTER", (KeyStroke)map.get("RETURN"));
        map.put("CR", (KeyStroke)map.get("RETURN"));
        map.put("PAGEUP", ConstructorWrappers.key(SpecialKey.PAGE_UP));
        map.put("PAGEDOWN", ConstructorWrappers.key(SpecialKey.PAGE_DOWN));
        map.put("UP", ConstructorWrappers.key(SpecialKey.ARROW_UP));
        map.put("DOWN", ConstructorWrappers.key(SpecialKey.ARROW_DOWN));
        map.put("LEFT", ConstructorWrappers.key(SpecialKey.ARROW_LEFT));
        map.put("RIGHT", ConstructorWrappers.key(SpecialKey.ARROW_RIGHT));
        map.put("TAB", ConstructorWrappers.key(SpecialKey.TAB));
        map.put("SPACE", ConstructorWrappers.key(' '));
        map.put("GT", ConstructorWrappers.key('>'));
        map.put("LT", ConstructorWrappers.key('<'));
        map.put("BAR", ConstructorWrappers.key('|'));
        map.put("LEADER", ConstructorWrappers.key(SpecialKey.LEADER));
        Set<KeyStroke.Modifier> modifiers = Collections.unmodifiableSet(EnumSet.of(KeyStroke.Modifier.CONTROL));
        map.put("C-@", new SimpleKeyStroke('@', modifiers));
        map.put("C-A", new SimpleKeyStroke('a', modifiers));
        map.put("C-B", new SimpleKeyStroke('b', modifiers));
        map.put("C-C", new SimpleKeyStroke('c', modifiers));
        map.put("C-D", new SimpleKeyStroke('d', modifiers));
        map.put("C-E", new SimpleKeyStroke('e', modifiers));
        map.put("C-F", new SimpleKeyStroke('f', modifiers));
        map.put("C-G", new SimpleKeyStroke('g', modifiers));
        map.put("C-H", new SimpleKeyStroke('h', modifiers));
        map.put("C-I", new SimpleKeyStroke('i', modifiers));
        map.put("C-J", new SimpleKeyStroke('j', modifiers));
        map.put("C-K", new SimpleKeyStroke('k', modifiers));
        map.put("C-L", new SimpleKeyStroke('l', modifiers));
        map.put("C-M", new SimpleKeyStroke('m', modifiers));
        map.put("C-N", new SimpleKeyStroke('n', modifiers));
        map.put("C-O", new SimpleKeyStroke('o', modifiers));
        map.put("C-P", new SimpleKeyStroke('p', modifiers));
        map.put("C-Q", new SimpleKeyStroke('q', modifiers));
        map.put("C-R", new SimpleKeyStroke('r', modifiers));
        map.put("C-S", new SimpleKeyStroke('s', modifiers));
        map.put("C-T", new SimpleKeyStroke('t', modifiers));
        map.put("C-U", new SimpleKeyStroke('u', modifiers));
        map.put("C-V", new SimpleKeyStroke('v', modifiers));
        map.put("C-W", new SimpleKeyStroke('w', modifiers));
        map.put("C-X", new SimpleKeyStroke('x', modifiers));
        map.put("C-Y", new SimpleKeyStroke('y', modifiers));
        map.put("C-Z", new SimpleKeyStroke('z', modifiers));
        map.put("C-[", new SimpleKeyStroke('[', modifiers));
        map.put("C-\\", new SimpleKeyStroke('\\', modifiers));
        map.put("C-]", new SimpleKeyStroke(']', modifiers));
        map.put("C-^", new SimpleKeyStroke('^', modifiers));
        map.put("C-_", new SimpleKeyStroke('_', modifiers));
        map.put("C-SPACE", new SimpleKeyStroke(' ', modifiers));
        return map;
    }
}

