/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap.vim;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.vim.PlugKeyStroke;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.vim.RemappedKeyStroke;

public abstract class AbstractPlugState<T>
implements State<T> {
    @Override
    public Transition<T> press(KeyStroke key) {
        if (SpecialKey.PLUG == key.getSpecialKey()) {
            if (key instanceof RemappedKeyStroke) {
                key = (PlugKeyStroke)((RemappedKeyStroke)key).unwrap();
            }
            if (!(key instanceof PlugKeyStroke)) {
                throw new VrapperPlatformException("Bad usage of PLUG key found, key is instance of " + key.getClass().getName() + " whereas " + PlugKeyStroke.class.getName() + " was expected.");
            }
            PlugKeyStroke plug = (PlugKeyStroke)key;
            if (plug.getId() == null || plug.getId().trim().length() == 0) {
                throw new VrapperPlatformException("Bad usage of PLUG key found, id is null, empty or solely whitespace.");
            }
            return this.press(plug.getId());
        }
        return null;
    }

    public abstract Transition<T> press(String var1);
}

