/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osee.framework.core.client.internal.InternalClientSessionManager;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcClientBuilder;
import org.eclipse.osee.jdbc.JdbcServerConfig;
import org.eclipse.osee.jdbc.JdbcService;

public class ClientJdbcServiceImpl
implements JdbcService {
    private final JdbcClientExtended clientProxy = this.createClientProxy();

    public String getId() {
        return this.clientProxy.getId();
    }

    public JdbcClient getClient() {
        return this.clientProxy;
    }

    public boolean hasServer() {
        return false;
    }

    public JdbcServerConfig getServerConfig() {
        return null;
    }

    public boolean isServerAlive(long waitTime) {
        return false;
    }

    private JdbcClientExtended createClientProxy() {
        JdbcClientInvocationHandler handler = new JdbcClientInvocationHandler();
        Class[] types = new Class[]{JdbcClientExtended.class};
        return (JdbcClientExtended)Proxy.newProxyInstance(this.getClass().getClassLoader(), types, (InvocationHandler)handler);
    }

    private static interface JdbcClientExtended
    extends JdbcClient {
        public String getId();
    }

    private final class JdbcClientInvocationHandler
    implements InvocationHandler {
        private volatile JdbcClient proxiedClient;

        private JdbcClientInvocationHandler() {
        }

        public String getId() {
            OseeSessionGrant dbInfo = this.getDbInfo();
            return dbInfo != null ? dbInfo.getDbId() : "N/A";
        }

        private boolean isGetId(Method method) {
            return "getid".equalsIgnoreCase(method.getName());
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object toReturn;
                if (this.isGetId(method)) {
                    toReturn = this.getId();
                } else {
                    JdbcClient client = this.getProxiedClient();
                    toReturn = method.invoke((Object)client, args);
                }
                return toReturn;
            }
            catch (Throwable ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                throw cause;
            }
        }

        private JdbcClient getProxiedClient() {
            OseeSessionGrant dbInfo;
            if (this.proxiedClient == null && (dbInfo = this.getDbInfo()) != null) {
                this.proxiedClient = this.newClient(dbInfo);
            }
            return this.proxiedClient;
        }

        private OseeSessionGrant getDbInfo() {
            OseeSessionGrant sessionGrant = InternalClientSessionManager.getInstance().getOseeSessionGrant();
            return sessionGrant;
        }

        private JdbcClient newClient(OseeSessionGrant sessionGrant) {
            JdbcClientBuilder builder = JdbcClientBuilder.newBuilder().dbDriver(sessionGrant.getDbDriver()).dbUri(sessionGrant.getDbUrl()).dbUsername(sessionGrant.getDbLogin()).production(sessionGrant.isDbIsProduction());
            Properties properties = sessionGrant.getDbConnectionProperties();
            if (properties != null && !properties.isEmpty()) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    builder.dbParam((String)entry.getKey(), (String)entry.getValue());
                }
            }
            return builder.build();
        }
    }
}

