/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow.transition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionWorkItemResult;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TransitionResults {
    boolean cancelled;
    private Set<ArtifactToken> workItemIds = new HashSet<ArtifactToken>();
    private List<TransitionResult> results = new ArrayList<TransitionResult>();
    private List<TransitionWorkItemResult> transitionWorkItems = new ArrayList<TransitionWorkItemResult>();
    private TransactionId transaction;
    private XResultData timeRd = new XResultData();
    private boolean debug = false;
    @JsonIgnore
    private AtsApi atsApi;

    public void addResult(IAtsWorkItem workItem, TransitionResult result) {
        TransitionWorkItemResult workItemResult = this.getTransitionWorkItemResult(workItem);
        if (workItemResult == null) {
            workItemResult = new TransitionWorkItemResult();
            workItemResult.setWorkItem(workItem);
            this.transitionWorkItems.add(workItemResult);
        }
        workItemResult.addResult(result);
        this.workItemIds.add(workItem.getStoreObject());
    }

    private TransitionWorkItemResult getTransitionWorkItemResult(IAtsWorkItem workItem) {
        for (TransitionWorkItemResult workItemResult : this.transitionWorkItems) {
            if (!workItem.getId().equals(workItemResult.getWorkItemId().getId())) continue;
            return workItemResult;
        }
        return null;
    }

    @JsonIgnore
    public void clear() {
        this.results.clear();
        this.transitionWorkItems.clear();
    }

    public void addResult(TransitionResult result) {
        this.results.add(result);
    }

    public boolean isEmpty() {
        return this.results.isEmpty() && this.transitionWorkItems.isEmpty();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean contains(String string) {
        return this.toString().contains(string);
    }

    public boolean contains(TransitionResult transitionResult) {
        return this.results.contains(transitionResult);
    }

    public boolean isEmpty(IAtsWorkItem workItem) {
        TransitionWorkItemResult transitionWorkItemResult = this.getTransitionWorkItemResult(workItem);
        return transitionWorkItemResult == null || transitionWorkItemResult.getResults().isEmpty();
    }

    public boolean contains(IAtsWorkItem workItem, TransitionResult transitionResult) {
        TransitionWorkItemResult transitionWorkItemResult = this.getTransitionWorkItemResult(workItem);
        if (transitionWorkItemResult != null) {
            return transitionWorkItemResult.getResults().contains(transitionResult);
        }
        return false;
    }

    @JsonIgnore
    public boolean isErrors() {
        return !this.isEmpty();
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.isEmpty();
    }

    @JsonIgnore
    public String getResultString() {
        if (this.results.isEmpty() && this.transitionWorkItems.isEmpty()) {
            return "<Empty>";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Reason(s):\n");
        this.appendResultsString(sb, this.results);
        for (TransitionWorkItemResult workItem : this.transitionWorkItems) {
            sb.append(workItem.getResultString());
        }
        return sb.toString();
    }

    public void appendResultsString(StringBuffer sb, List<TransitionResult> results) {
        for (TransitionResult result : results) {
            sb.append("    - ");
            sb.append(result.getDetails());
            if (Strings.isValid((String)result.getException()) && Strings.isValid((String)result.getException())) {
                sb.append(" - Exception [");
                sb.append(result.getException());
                sb.append("] (see log for details)");
            }
            sb.append("\n");
        }
    }

    @JsonIgnore
    public XResultData getResultsAsXResultData() {
        XResultData resultData = new XResultData(false);
        resultData.log("Transition Failed");
        String str = this.getResultString();
        resultData.addRaw(str);
        return resultData;
    }

    public String toString() {
        return this.getResultString();
    }

    public List<TransitionResult> getResults() {
        return this.results;
    }

    @JsonIgnore
    public AtsApi getAtsApi() {
        return this.atsApi;
    }

    public void setAtsApi(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public List<TransitionWorkItemResult> getTransitionWorkItems() {
        return this.transitionWorkItems;
    }

    public void setTransitionWorkItems(List<TransitionWorkItemResult> transitionWorkItems) {
        this.transitionWorkItems = transitionWorkItems;
        if (!transitionWorkItems.isEmpty()) {
            this.workItemIds.clear();
            for (TransitionWorkItemResult transitionWorkItemResult : transitionWorkItems) {
                this.workItemIds.add(transitionWorkItemResult.getWorkItemId());
            }
        }
    }

    public void setResults(List<TransitionResult> results) {
        this.results = results;
    }

    @JsonIgnore
    public Collection<IAtsWorkItem> getWorkItems() {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
        return workItems;
    }

    public Set<ArtifactToken> getWorkItemIds() {
        return this.workItemIds;
    }

    public void setWorkItemIds(Set<ArtifactToken> workItemIds) {
        this.workItemIds = workItemIds;
    }

    public TransactionId getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionId transaction) {
        this.transaction = transaction;
    }

    public XResultData getTimeRd() {
        return this.timeRd;
    }

    public void setTimeRd(XResultData timeRd) {
        this.timeRd = timeRd;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

