/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.query.AtsSearchUserType;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.review.ReviewFormalType;
import org.eclipse.osee.ats.api.util.AttributeValues;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class AtsSearchData {
    @JsonSerialize(using=ToStringSerializer.class)
    private Long id;
    private String searchName = "";
    private String changeType = "";
    private String userId = "";
    private String title = "";
    private List<StateType> stateTypes = new LinkedList<StateType>();
    private AtsSearchUserType userType;
    private List<WorkItemType> workItemTypes = new LinkedList<WorkItemType>();
    private List<Long> teamDefIds = new LinkedList<Long>();
    private List<Long> aiIds = new LinkedList<Long>();
    private Long versionId = 0L;
    private String state = "";
    @JsonSerialize(using=ToStringSerializer.class)
    private Long programId = 0L;
    @JsonSerialize(using=ToStringSerializer.class)
    private Long insertionId = 0L;
    @JsonSerialize(using=ToStringSerializer.class)
    private Long insertionActivityId = 0L;
    @JsonSerialize(using=ToStringSerializer.class)
    private Long workPackageId = 0L;
    private String colorTeam = "";
    private String namespace = "";
    private ReviewFormalType reviewType;
    private ReleasedOption releasedOption;
    private CustomizeData customizeData;
    private AttributeValues attrValues;

    public AtsSearchData() {
        this.id = Lib.generateId();
        this.attrValues = new AttributeValues();
    }

    public AtsSearchData(String searchName) {
        this();
        this.searchName = searchName;
    }

    @JsonIgnore
    public AtsSearchData copy() {
        AtsSearchData item = new AtsSearchData(this.searchName);
        return this.copy(item);
    }

    protected AtsSearchData copy(AtsSearchData item) {
        item.id = this.id;
        item.setTitle(this.getTitle());
        item.getStateTypes().addAll(this.getStateTypes());
        item.setUserType(this.getUserType());
        item.setUserId(this.getUserId());
        item.getWorkItemTypes().addAll(this.getWorkItemTypes());
        item.setTeamDefIds(this.getTeamDefIds());
        item.setAiIds(this.getAiIds());
        item.setVersionId(this.getVersionId());
        item.setState(this.getState());
        item.setChangeType(this.getChangeType());
        item.setProgramId(this.getProgramId());
        item.setInsertionId(this.getInsertionId());
        item.setInsertionActivityId(this.getInsertionActivityId());
        item.setWorkPackageId(this.getWorkPackageId());
        item.setColorTeam(this.getColorTeam());
        item.setReviewType(this.getReviewType());
        item.setAttrValues(this.getAttrValues());
        return item;
    }

    public AtsSearchUserType getUserType() {
        return this.userType;
    }

    public void setUserType(AtsSearchUserType userType) {
        this.userType = userType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        Conditions.checkExpressionFailOnTrue((id <= 0L ? 1 : 0) != 0, (String)"Can't set id to 0", (Object[])new Object[0]);
        this.id = id;
    }

    public String toString() {
        return this.searchName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<StateType> getStateTypes() {
        return this.stateTypes;
    }

    public void setStateTypes(List<StateType> stateTypes) {
        this.stateTypes = stateTypes;
    }

    public List<WorkItemType> getWorkItemTypes() {
        return this.workItemTypes;
    }

    public void setWorkItemTypes(List<WorkItemType> workItemTypes) {
        this.workItemTypes = workItemTypes;
    }

    public List<Long> getTeamDefIds() {
        return this.teamDefIds;
    }

    public void setTeamDefIds(List<Long> teamDefIds) {
        this.teamDefIds = teamDefIds;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public List<Long> getAiIds() {
        return this.aiIds;
    }

    public void setAiIds(List<Long> aiIds) {
        this.aiIds = aiIds;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Long getProgramId() {
        return this.programId;
    }

    public void setProgramId(Long programId) {
        this.programId = programId;
    }

    public Long getInsertionId() {
        return this.insertionId;
    }

    public void setInsertionId(Long insertionId) {
        this.insertionId = insertionId;
    }

    public Long getInsertionActivityId() {
        return this.insertionActivityId;
    }

    public void setInsertionActivityId(Long insertionActivityId) {
        this.insertionActivityId = insertionActivityId;
    }

    public Long getWorkPackageId() {
        return this.workPackageId;
    }

    public void setWorkPackageId(Long workPackageId) {
        this.workPackageId = workPackageId;
    }

    public String getColorTeam() {
        return this.colorTeam;
    }

    public void setColorTeam(String colorTeam) {
        this.colorTeam = colorTeam;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ReviewFormalType getReviewType() {
        return this.reviewType;
    }

    public void setReviewType(ReviewFormalType reviewType) {
        this.reviewType = reviewType;
    }

    public ReleasedOption getReleasedOption() {
        return this.releasedOption;
    }

    public void setReleasedOption(ReleasedOption releasedOption) {
        this.releasedOption = releasedOption;
    }

    public CustomizeData getCustomizeData() {
        return this.customizeData;
    }

    public void setCustomizeData(CustomizeData customizeData) {
        this.customizeData = customizeData;
    }

    public AttributeValues getAttrValues() {
        return this.attrValues;
    }

    public void setAttrValues(AttributeValues attrValues) {
        this.attrValues = attrValues;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
}

