/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.console;

import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;

public class ServerScheduleCommand
implements ConsoleCommand {
    public String getName() {
        return "server_schedule_cmd";
    }

    public String getDescription() {
        return "Schedules a console command";
    }

    public String getUsage() {
        return "iterate=<NUMBER_OF_TIMES_TO_SCHEDULE> delay=<DELAY_IN_SECONDS> cmd=\"<CMD + PARAMETERS>\"";
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        return new SchedulingCallable(console, params);
    }

    private final class SchedulingCallable
    implements Callable<Boolean> {
        private final Console ci;
        private final ConsoleParameters params;

        public SchedulingCallable(Console ci, ConsoleParameters params) {
            this.ci = ci;
            this.params = params;
        }

        @Override
        public Boolean call() throws Exception {
            long delayMiliseconds = (long)this.params.getInt("delay") * 1000L;
            int iterations = this.params.getInt("iterate");
            String command = this.params.get("cmd");
            int i = 0;
            while (i < iterations) {
                Thread.sleep(delayMiliseconds);
                this.ci.execute(command);
                ++i;
            }
            return Boolean.TRUE;
        }
    }
}

