/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class XNavigateItemAction
extends XNavigateItem {
    private final Action action;
    private boolean promptFirst = false;
    private Collection<IUserGroupArtifactToken> groups;

    public XNavigateItemAction(String name, XNavItemCat ... xNavItemCat) {
        this(name, false, null, xNavItemCat);
    }

    public XNavigateItemAction(String name, KeyedImage oseeImage, XNavItemCat ... xNavItemCat) {
        this(name, false, oseeImage, xNavItemCat);
    }

    public XNavigateItemAction(String name, OseeImage oseeImage, XNavItemCat ... xNavItemCat) {
        this(name, false, ImageManager.create((OseeImage)oseeImage), xNavItemCat);
    }

    public XNavigateItemAction(String name, boolean promptFirst, KeyedImage oseeImage, XNavItemCat ... xNavItemCat) {
        super(name, oseeImage, xNavItemCat);
        this.action = null;
        this.promptFirst = promptFirst;
    }

    public XNavigateItemAction(Action action, KeyedImage oseeImage, XNavItemCat ... xNavItemCat) {
        this(action, oseeImage, false, Collections.emptyList(), xNavItemCat);
    }

    public XNavigateItemAction(Action action, KeyedImage oseeImage, Collection<IUserGroupArtifactToken> groups, XNavItemCat ... xNavItemCat) {
        this(action, oseeImage, false, groups, xNavItemCat);
    }

    public XNavigateItemAction(Action action, OseeImage oseeImage, XNavItemCat ... xNavItemCat) {
        this(action, ImageManager.create((OseeImage)oseeImage), false, Collections.emptyList(), xNavItemCat);
    }

    public XNavigateItemAction(Action action, OseeImage oseeImage, boolean promptFirst, XNavItemCat ... xNavItemCat) {
        this(action, ImageManager.create((OseeImage)oseeImage), promptFirst, Collections.emptyList(), xNavItemCat);
    }

    public XNavigateItemAction(Action action, KeyedImage oseeImage, boolean promptFirst, XNavItemCat ... xNavItemCat) {
        this(action, oseeImage, promptFirst, (Collection<IUserGroupArtifactToken>)null, xNavItemCat);
    }

    public XNavigateItemAction(Action action, KeyedImage oseeImage, boolean promptFirst, Collection<IUserGroupArtifactToken> groups, XNavItemCat ... xNavItemCat) {
        super(action.getText(), oseeImage, xNavItemCat);
        this.action = action;
        this.promptFirst = promptFirst;
        this.groups = groups;
    }

    @Override
    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        if (this.action != null) {
            if (this.promptFirst) {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)XNavigateItemAction.this.getName(), (String)(String.valueOf(XNavigateItemAction.this.getName()) + "?"))) {
                            XNavigateItemAction.this.action.run();
                        }
                    }
                });
            } else if (this.action.getStyle() == 2) {
                this.action.setChecked(!this.action.isChecked());
                if (this.action.isChecked()) {
                    this.action.run();
                }
            } else {
                this.action.run();
            }
        }
    }

    public boolean isPromptFirst() {
        return this.promptFirst;
    }

    public void setPromptFirst(boolean promptFirst) {
        this.promptFirst = promptFirst;
    }

    @Override
    public Collection<IUserGroupArtifactToken> getUserGroups() {
        if (this.groups != null && !this.groups.isEmpty()) {
            return this.groups;
        }
        if (this.categories.contains((Object)XNavItemCat.OSEE_ADMIN)) {
            return Arrays.asList(CoreUserGroups.OseeAdmin);
        }
        return Arrays.asList(CoreUserGroups.Everyone);
    }
}

