/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.xnavigate.INavigateItemRefresher;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemProvider;

public class NavigateItemCollector {
    public List<XNavigateItem> compNavItems = new ArrayList<XNavigateItem>();
    private final Map<String, XNavigateItem> catStrToItem = new HashMap<String, XNavigateItem>();
    private final Collection<XNavigateItemProvider> providers;
    List<XNavigateItem> items = new ArrayList<XNavigateItem>();
    private final INavigateItemRefresher refresher;
    private final XResultData rd;
    private Collection<? extends ArtifactId> currUserUserGroups;

    public NavigateItemCollector(Collection<XNavigateItemProvider> providers, INavigateItemRefresher refresher, XResultData rd) {
        this.providers = providers;
        this.refresher = refresher;
        this.rd = rd;
    }

    public List<XNavigateItem> getComputedNavItems(Collection<? extends ArtifactId> currUserUserGroups) {
        this.currUserUserGroups = currUserUserGroups;
        if (this.compNavItems.isEmpty()) {
            for (XNavigateItemProvider provider : this.providers) {
                if (!provider.isApplicable()) continue;
                provider.getNavigateItems(this.items);
            }
            if (this.refresher != null) {
                for (XNavigateItem item : this.items) {
                    item.setRefresher(this.refresher);
                }
            }
            this.createCategoryHierarchy();
            this.createChildren();
        }
        return this.compNavItems;
    }

    private void createChildren() {
        for (XNavigateItem item : this.items) {
            for (XNavItemCat itemCat : item.getCategories()) {
                if (itemCat == null) {
                    this.rd.errorf("XNavItemCat can not be null\n", new Object[]{itemCat});
                    continue;
                }
                if (itemCat.equals((Object)XNavItemCat.OSEE_ADMIN) || !this.currentUserInUserGroups(item)) continue;
                XNavigateItem foundParent = this.catStrToItem.get(itemCat.getName());
                if (foundParent == null) {
                    this.rd.errorf("Children: Can't find parent [%s] for item [%s]\n", new Object[]{itemCat.getName(), item.getName()});
                    continue;
                }
                foundParent.addChild(item);
            }
        }
    }

    private boolean currentUserInUserGroups(XNavigateItem item) {
        Collection<IUserGroupArtifactToken> itemUserGroups = item.getUserGroups();
        if (itemUserGroups.isEmpty()) {
            return true;
        }
        for (ArtifactId artifactId : this.currUserUserGroups) {
            if (!itemUserGroups.contains(artifactId)) continue;
            return true;
        }
        return false;
    }

    private void createCategoryHierarchy() {
        for (XNavItemCat topCat : XNavItemCat.orderedValues()) {
            for (XNavigateItem item : new ArrayList<XNavigateItem>(this.items)) {
                Collection<XNavItemCat> categories;
                if (!this.currentUserInUserGroups(item) || !(categories = item.getCategories()).contains((Object)topCat)) continue;
                this.rd.logf("Adding Category [%s]\n", new Object[]{item.getName()});
                if (!this.catStrToItem.containsKey(item.getName())) {
                    this.catStrToItem.put(item.getName(), item);
                    this.compNavItems.add(item);
                }
                this.items.remove(item);
            }
        }
        for (XNavigateItem item : new ArrayList<XNavigateItem>(this.items)) {
            Collection<XNavItemCat> categories;
            if (!this.currentUserInUserGroups(item) || !(categories = item.getCategories()).contains((Object)XNavItemCat.SUBCAT)) continue;
            categories.remove((Object)XNavItemCat.SUBCAT);
            categories.remove((Object)XNavItemCat.OSEE_ADMIN);
            block3: for (XNavItemCat itemCat : categories) {
                String catStr = itemCat.getName();
                while (Strings.isValid((String)catStr) && catStr.contains(".")) {
                    XNavigateItem parentItem = this.catStrToItem.get(catStr);
                    if (parentItem != null) continue block3;
                    this.rd.logf("\nSearching from Category Str [%s]\n", new Object[]{catStr});
                    catStr = this.getReducedCat(catStr);
                    this.rd.logf("-- Reduced category to [%s]\n", new Object[]{catStr});
                    if (!Strings.isValid((String)catStr)) continue;
                    parentItem = this.catStrToItem.get(catStr);
                    if (parentItem != null) {
                        parentItem.addChild(item);
                        this.rd.logf("Adding Sub-Category name [%s] id [%s]\n", new Object[]{item.getName(), catStr});
                        this.catStrToItem.put(itemCat.getName(), item);
                        this.items.remove(item);
                        continue block3;
                    }
                    this.rd.errorf("Sub-Cat: Can't find parent [%s] for item [%s]\n", new Object[]{catStr, item.getName()});
                }
            }
        }
    }

    private String getReducedCat(String catStr) {
        String[] names = catStr.split("\\.");
        StringBuilder sb = new StringBuilder();
        int x = 0;
        while (x < names.length - 1) {
            if (x > 0) {
                sb.append(".");
            }
            sb.append(names[x]);
            ++x;
        }
        return sb.toString();
    }

    public List<XNavigateItem> getItems() {
        return this.items;
    }
}

