/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.OseeUiActivator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public final class AWorkbench {
    public static final int SCROLLING_TEXT_BOX = 1;
    public static final int INCLUDE_CANCEL_BUTTON = 2;

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return workbenchWindow != null ? workbenchWindow.getActivePage() : null;
    }

    public static Shell getActiveShell() {
        return AWorkbench.getDisplay().getActiveShell();
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static List<IEditorReference> getEditors() {
        ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>();
        IWorkbenchPage[] iWorkbenchPageArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference editor = iEditorReferenceArray[n4];
                editors.add(editor);
                ++n4;
            }
            ++n2;
        }
        return editors;
    }

    public static List<IEditorReference> getEditors(String editorId) {
        ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>();
        for (IEditorReference editor : AWorkbench.getEditors()) {
            if (!editor.getId().equals(editorId)) continue;
            editors.add(editor);
        }
        return editors;
    }

    public static Color getSystemColor(int id) {
        return AWorkbench.getDisplay().getSystemColor(id);
    }

    public static IViewPart getView(String viewId) {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(viewId);
    }

    public static void openPerspective(final String perspId) {
        final IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPerspectiveDescriptor activePerspective = workbenchWindow.getActivePage().getPerspective();
        if (activePerspective == null || !activePerspective.getId().equals(perspId)) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        workbenchWindow.getWorkbench().showPerspective(perspId, workbenchWindow);
                    }
                    catch (WorkbenchException ex) {
                        OseeLog.log(OseeUiActivator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
        }
    }

    public static void popup(Composite comp, String title, String message) {
        MessageDialog.openInformation((Shell)comp.getShell(), (String)title, (String)message);
    }

    public static void popup(final MessageType messageType, final String title, final String message) {
        if (!PlatformUI.isWorkbenchRunning()) {
            OseeLog.log(AWorkbench.class, (Level)Level.SEVERE, (String)message);
        } else {
            AWorkbench.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (messageType == MessageType.Informational) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
                    } else if (messageType == MessageType.Error) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
                    } else if (messageType == MessageType.Confirm) {
                        MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
                    }
                }
            });
        }
    }

    public static void popup(final MessageType messageType, final String title, final String message, final String longMessage, final Map<String, Runnable> buttonActions, final int options) {
        boolean scrollingTextBox;
        if (!PlatformUI.isWorkbenchRunning()) {
            String logMessage = new Message().title((CharSequence)title).indentInc().block((CharSequence)message).followsIfNonNull((CharSequence)"Reason Follows", (CharSequence)longMessage).toString();
            OseeLog.log(AWorkbench.class, (Level)Level.SEVERE, (String)logMessage);
        }
        boolean bl = scrollingTextBox = (options & 1) > 0;
        if (!scrollingTextBox) {
            AWorkbench.popup(messageType, title, message);
            return;
        }
        AWorkbench.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Runnable buttonAction;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                Shell shell = window.getShell();
                final String[] buttonLabels = messageType.getButtonLabels(options);
                var messageDialog = new MessageDialog(shell, title, null, message, messageType.getKind(), 0, buttonLabels){

                    protected Control createCustomArea(Composite parent) {
                        GridData textGridData = new GridData();
                        textGridData.horizontalAlignment = 4;
                        textGridData.grabExcessHorizontalSpace = true;
                        textGridData.minimumWidth = 128;
                        textGridData.widthHint = 128;
                        textGridData.verticalAlignment = 4;
                        textGridData.grabExcessVerticalSpace = true;
                        textGridData.minimumHeight = 256;
                        textGridData.heightHint = 256;
                        Text text = new Text(parent, 2818);
                        text.setEditable(false);
                        text.setLayoutData((Object)textGridData);
                        text.setText(longMessage);
                        return text;
                    }

                    String display() {
                        int defaultStyles = this.getShellStyle();
                        this.setShellStyle(defaultStyles | 0x10);
                        int pressedButtonIndex = this.open();
                        String pressedButton = pressedButtonIndex >= 0 && pressedButtonIndex < buttonLabels.length ? buttonLabels[pressedButtonIndex] : IDialogConstants.OK_LABEL;
                        return pressedButton;
                    }
                };
                String pressedButton = messageDialog.display();
                if (buttonActions != null && (buttonAction = (Runnable)buttonActions.get(pressedButton)) != null) {
                    buttonAction.run();
                }
            }
        });
    }

    public static void popup(Result result) {
        AWorkbench.popup(null, result);
    }

    public static void popup(String message) {
        AWorkbench.popup(message, message);
    }

    public static void popup(String title, Result result) {
        AWorkbench.popup(Strings.isValid((String)title) ? title : (result.isTrue() ? "Success" : "ERROR"), Strings.isValid((String)result.getText()) ? result.getText() : (result.isTrue() ? "Success" : "Error Encountered.  See Error Log View"));
    }

    public static void popup(String title, String message) {
        AWorkbench.popup(MessageType.Informational, title, message);
    }

    public static void popup(String title, String messageFormat, Object ... data) {
        AWorkbench.popup(MessageType.Informational, title, String.format(messageFormat, data));
    }

    public static void popupf(String string, Object ... data) {
        AWorkbench.popup(String.format(string, data));
    }

    public static boolean popupView(String iPageLayoutView) {
        IViewPart p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(iPageLayoutView);
        if (p != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)p);
            return true;
        }
        return false;
    }

    public static enum MessageType {
        Confirm{

            @Override
            protected int getKind() {
                return 5;
            }

            @Override
            protected String[] getButtonLabels(int options) {
                return OK_CANCEL_BUTTON_SET;
            }
        }
        ,
        Error{

            @Override
            protected int getKind() {
                return 1;
            }

            @Override
            protected String[] getButtonLabels(int options) {
                return (options & 2) > 0 ? OK_CANCEL_BUTTON_SET : OK_BUTTON_SET;
            }
        }
        ,
        Informational{

            @Override
            protected int getKind() {
                return 2;
            }

            @Override
            protected String[] getButtonLabels(int options) {
                return OK_BUTTON_SET;
            }
        };

        private static final String[] OK_BUTTON_SET;
        public static final String[] OK_CANCEL_BUTTON_SET;

        static {
            OK_BUTTON_SET = new String[]{IDialogConstants.OK_LABEL};
            OK_CANCEL_BUTTON_SET = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        }

        protected abstract int getKind();

        protected abstract String[] getButtonLabels(int var1);
    }
}

