/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilder;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilderFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.graph.GraphFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;

public class TxDataLoaderImpl
implements TxDataManager.TxDataLoader {
    private final DataLoaderFactory dataLoaderFactory;
    private final GraphFactory graphFactory;
    private final GraphBuilderFactory graphBuilderFactory;
    private final GraphProvider graphProvider;
    private final TransactionProvider txProvider;

    public TxDataLoaderImpl(DataLoaderFactory dataLoaderFactory, GraphFactory graphFactory, GraphBuilderFactory graphBuilderFactory, GraphProvider graphProvider, TransactionProvider txProvider) {
        this.dataLoaderFactory = dataLoaderFactory;
        this.graphProvider = graphProvider;
        this.graphFactory = graphFactory;
        this.graphBuilderFactory = graphBuilderFactory;
        this.txProvider = txProvider;
    }

    private DataLoader createLoader(OrcsSession session, BranchId branch, Collection<ArtifactId> artifactIds) {
        LinkedHashSet<ArtifactId> ids = new LinkedHashSet<ArtifactId>();
        for (ArtifactId artifactId : artifactIds) {
            ids.add(artifactId);
        }
        DataLoader loader = this.dataLoaderFactory.newDataLoaderFromIds(session, branch, artifactIds);
        loader.withLoadLevel(LoadLevel.ALL);
        loader.includeDeletedAttributes();
        loader.includeDeletedRelations();
        return loader;
    }

    @Override
    public ResultSet<Artifact> loadArtifact(OrcsSession session, BranchId branch, ArtifactId artifactId) {
        DataLoader loader = this.createLoader(session, branch, Collections.singleton(artifactId));
        GraphBuilder handler = this.graphBuilderFactory.createGraphBuilder(this.graphProvider);
        loader.load(null, handler);
        return ResultSets.newResultSet(handler.getArtifacts());
    }

    @Override
    public ResultSet<Artifact> loadArtifacts(OrcsSession session, GraphData graph, Collection<ArtifactId> artifactIds) {
        DataLoader loader = this.createLoader(session, graph.getBranch(), artifactIds);
        loader.fromTransaction(graph.getTransaction());
        loader.fromBranchView(graph.getBranch().getViewId());
        GraphBuilder handler = this.graphBuilderFactory.createBuilderForGraph(graph);
        loader.load(null, handler);
        return ResultSets.newResultSet(handler.getArtifacts());
    }

    @Override
    public GraphData createGraph(OrcsSession session, BranchId branch) {
        TransactionId headTransaction = this.txProvider.getHeadTransaction(session, branch);
        return this.graphFactory.createGraph(session, branch, headTransaction);
    }

    public static interface TransactionProvider {
        public TransactionId getHeadTransaction(OrcsSession var1, BranchId var2);
    }
}

