/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.graph.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.LoadDescription;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManager;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilder;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationFactory;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeAdjacencies;

public class GraphBuilderImpl
extends LoadDataHandlerAdapter
implements GraphBuilder {
    private final Log logger;
    private final ArtifactFactory artifactFactory;
    private final AttributeFactory attributeFactory;
    private final RelationFactory relationFactory;
    private final GraphProvider graphProvider;
    private final Set<Artifact> updated = new LinkedHashSet<Artifact>();
    private GraphData graph;

    public GraphBuilderImpl(Log logger, ArtifactFactory artifactFactory, AttributeFactory attributeFactory, RelationFactory relationFactory, GraphProvider graphProvider) {
        this.logger = logger;
        this.graphProvider = graphProvider;
        this.artifactFactory = artifactFactory;
        this.attributeFactory = attributeFactory;
        this.relationFactory = relationFactory;
    }

    @Override
    public void onLoadStart() {
        this.graph = null;
    }

    private GraphData getGraph() {
        Conditions.checkNotNull((Object)this.graph, (String)"graph");
        return this.graph;
    }

    @Override
    public void onLoadDescription(LoadDescription data) {
        this.graph = this.graphProvider.getGraph(data.getSession(), data.getBranch(), data.getTransaction());
        Conditions.checkNotNull((Object)this.graph, (String)"graph");
    }

    @Override
    public void onData(ArtifactData data) {
        GraphData graph = this.getGraph();
        Artifact artifact = (Artifact)graph.getNode((ArtifactId)data);
        if (artifact == null) {
            artifact = this.artifactFactory.createArtifact(graph.getSession(), data);
            graph.addNode(artifact, ((ArtifactData)artifact.getOrcsData()).isExistingVersionUsed());
            RelationNodeAdjacencies adjacencies = this.relationFactory.createRelationContainer();
            graph.addAdjacencies((ArtifactId)data, adjacencies);
        }
        this.updated.add(artifact);
    }

    @Override
    public <T> void onData(AttributeData<T> data) {
        GraphData graph = this.getGraph();
        AttributeManager container = (AttributeManager)graph.getNode(data.getArtifactId());
        if (container == null) {
            this.logger.warn("Orphaned attribute detected - data[%s]", new Object[]{data});
        } else {
            this.attributeFactory.createAttribute(container, data);
        }
    }

    @Override
    public void onData(RelationData data) {
        GraphData graph = this.getGraph();
        RelationNodeAdjacencies aAdjacencies = this.getAdjacencies(graph, data.getArtifactIdA());
        RelationNodeAdjacencies bAdjacencies = this.getAdjacencies(graph, data.getArtifactIdB());
        Relation relation = this.findRelation(aAdjacencies, data);
        if (relation == null) {
            relation = this.findRelation(bAdjacencies, data);
        }
        if (relation == null) {
            relation = this.relationFactory.createRelation(data);
        }
        RelationTypeToken relationType = (RelationTypeToken)data.getType();
        aAdjacencies.add(relationType, relation);
        bAdjacencies.add(relationType, relation);
    }

    private Relation findRelation(RelationNodeAdjacencies adjacencies, RelationData data) {
        if (((RelationTypeToken)data.getType()).isNewRelationTable()) {
            return adjacencies.getRelation(data.getArtifactIdA(), (RelationTypeToken)data.getType(), data.getArtifactIdB(), data.getRelOrder(), DeletionFlag.EXCLUDE_DELETED);
        }
        return adjacencies.getRelation(data.getArtifactIdA(), (RelationTypeToken)data.getType(), data.getArtifactIdB());
    }

    private RelationNodeAdjacencies getAdjacencies(GraphData graph, ArtifactId id) {
        RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)graph.getAdjacencies(id);
        if (adjacencies == null) {
            adjacencies = this.relationFactory.createRelationContainer();
            graph.addAdjacencies(id, adjacencies);
        }
        return adjacencies;
    }

    @Override
    public void onLoadEnd() {
    }

    @Override
    public Iterable<Artifact> getArtifacts() {
        return this.updated;
    }

    @Override
    public Iterable<GraphData> getGraphs() {
        return this.graph != null ? Collections.singleton(this.graph) : Collections.emptyList();
    }
}

