/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CIUserGroups;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.MimArtifactTokens;
import org.eclipse.osee.framework.core.enums.MimUserGroups;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.SetupPublishing;
import org.eclipse.osee.orcs.core.internal.access.BootstrapUsers;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class CreateSystemBranches {
    private final OrcsApi orcsApi;
    private final TransactionFactory txFactory;
    private final QueryBuilder query;
    private static final String JSON_ATTR_VALUE = "{ \"WCAFE\" : [{\"TypeId\" : 204509162766372, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 1, \"Max\" : 99}, {\"Min\" : 1001, \"Max\" : 1009}]},{\"TypeId\" : 204509162766372, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 1, \"Max\" : 49}]},{\"TypeId\" : 204509162766372, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1, \"Max\" : 99}, {\"Min\" : 1001, \"Max\" : 1009}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 100, \"Max\" : 199}, {\"Min\" : 1100, \"Max\" : 1199}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 50, \"Max\" : 199}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 100, \"Max\" : 199}, {\"Min\" : 1100, \"Max\" : 1199}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 400}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 400}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1}]}]}";
    private static final String JSON_PL_PREFERENCES = "{ \"FileExtensionCommentStyle\" : [\n      { \"FileExtension\" : \"fileApplicability\", \"CommentPrefixRegex\" : \"\", \"CommentSuffixRegex\" : \"\", \"CommentPrefix\" : \"\", \"CommentSuffix\" : \"\"},\n      { \"FileExtension\" : \"txt\", \"CommentPrefixRegex\" : \"\", \"CommentSuffixRegex\" : \"\", \"CommentPrefix\" : \"\", \"CommentSuffix\" : \"\"},\n      { \"FileExtension\" : \"VMF\", \"CommentPrefixRegex\" : \"%\", \"CommentPrefix\" : \"% \" },\n      { \"FileExtension\" : \"mdgsource\", \"CommentPrefixRegex\" : \"\\\\+\\\\.\", \"CommentPrefix\" : \"+. \" },\n      { \"FileExtension\" : \"java\", \"CommentPrefixRegex\" : \"/\\\\*\", \"CommentSuffixRegex\" : \"\\\\*/\", \"CommentPrefix\" : \"/* \", \"CommentSuffix\" : \" */\"},\n      { \"FileExtension\" : \"cpp\", \"CommentPrefixRegex\" : \"//\", \"CommentPrefix\" : \"// \" },\n      { \"FileExtension\" : \"cmd\", \"CommentPrefixRegex\" : \"REM\", \"CommentPrefix\" : \"REM \" },\n      { \"FileExtension\" : \"xml\", \"CommentPrefixRegex\" : \"<!--\", \"CommentSuffixRegex\" : \"-->\", \"CommentPrefix\" : \"<!-- \", \"CommentSuffix\" : \" -->\"},\n      { \"FileExtension\" : \"lst\", \"CommentPrefixRegex\" : \"#\", \"CommentPrefix\" : \"# \" }\n      ]}";

    public CreateSystemBranches(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.txFactory = orcsApi.getTransactionFactory();
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
    }

    public TransactionId create(UserToken superUser) {
        this.orcsApi.getKeyValueOps().putByKey((Id)ApplicabilityToken.BASE, ApplicabilityToken.BASE.getName());
        SetupPublishing.setupConfiguration(this.orcsApi);
        this.populateSystemBranch();
        this.orcsApi.getBranchOps().createTopLevelBranch(CoreBranches.COMMON);
        return this.populateCommonBranch(superUser);
    }

    private void populateSystemBranch() {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.SYSTEM_ROOT, "Add System Root branch artifacts");
        tx.createArtifact(CoreArtifactTokens.DefaultHierarchyRoot);
        tx.createArtifact(CoreArtifactTokens.UniversalGroupRoot);
        tx.commit();
    }

    private TransactionId populateCommonBranch(UserToken superUser) {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, "Add Common branch artifacts");
        this.orcsApi.tokenService().getArtifactTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        this.orcsApi.tokenService().getAttributeTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        this.orcsApi.tokenService().getRelationTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        ArtifactReadable root = (ArtifactReadable)this.query.andIsHeirarchicalRootArtifact().getResults().getExactlyOne();
        ArtifactToken oseeConfig = tx.createArtifact((ArtifactId)root, CoreArtifactTokens.OseeConfiguration);
        ArtifactToken userGroupsFolder = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.UserGroups);
        ArtifactToken everyOne = tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.Everyone);
        tx.setSoleAttributeValue((ArtifactId)everyOne, (AttributeTypeToken)CoreAttributeTypes.DefaultGroup, (Object)true);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.OseeAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.AccountAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.OseeAccessAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.Publishing);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)MimUserGroups.MimAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CIUserGroups.CIAdmin);
        ArtifactToken prefArt = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)CoreArtifactTokens.GlobalPreferences).getArtifactOrSentinal();
        if (prefArt.isInvalid()) {
            prefArt = tx.createArtifact(CoreArtifactTokens.GlobalPreferences);
        }
        tx.setSoleAttributeValue((ArtifactId)prefArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)JSON_ATTR_VALUE);
        tx.setSoleAttributeValue((ArtifactId)prefArt, (AttributeTypeToken)CoreAttributeTypes.ProductLinePreferences, (Object)JSON_PL_PREFERENCES);
        tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.XViewerCustomization);
        tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.DocumentTemplates);
        SetupPublishing.setup(tx);
        ArtifactToken mimFolder = tx.createArtifact((ArtifactId)oseeConfig, MimArtifactTokens.MimConfigFolder);
        ArtifactToken mimIcdReport = tx.createArtifact((ArtifactId)mimFolder, MimArtifactTokens.MimIcdReport);
        tx.setSoleAttributeValue((ArtifactId)mimIcdReport, (AttributeTypeToken)CoreAttributeTypes.EndpointUrl, (Object)"/mim/branch/<branchId>/view/<viewId>/icd/<connectionId>?diff=<diffAvailable>&showErrors=<showErrors>");
        tx.setSoleAttributeValue((ArtifactId)mimIcdReport, (AttributeTypeToken)CoreAttributeTypes.DiffAvailable, (Object)true);
        tx.setSoleAttributeValue((ArtifactId)mimIcdReport, (AttributeTypeToken)CoreAttributeTypes.FileExtension, (Object)"xlsx");
        tx.setSoleAttributeValue((ArtifactId)mimIcdReport, (AttributeTypeToken)CoreAttributeTypes.FileNamePrefix, (Object)"InterfaceWorkbook");
        tx.setSoleAttributeValue((ArtifactId)mimIcdReport, (AttributeTypeToken)CoreAttributeTypes.HttpMethod, (Object)"GET");
        tx.setSoleAttributeValue((ArtifactId)mimIcdReport, (AttributeTypeToken)CoreAttributeTypes.ProducesMediaType, (Object)"application/octet-stream");
        tx.setSoleAttributeValue((ArtifactId)mimIcdReport, (AttributeTypeToken)CoreAttributeTypes.RequiresValidation, (Object)true);
        tx.setSoleAttributeValue((ArtifactId)mimIcdReport, (AttributeTypeToken)CoreAttributeTypes.SupportsErrorColoring, (Object)true);
        ArtifactToken mimIcdImport = tx.createArtifact((ArtifactId)mimFolder, MimArtifactTokens.MimIcdImport);
        tx.setSoleAttributeValue((ArtifactId)mimIcdImport, (AttributeTypeToken)CoreAttributeTypes.EndpointUrl, (Object)"/mim/import/icd/<branchId>");
        tx.setSoleAttributeValue((ArtifactId)mimIcdImport, (AttributeTypeToken)CoreAttributeTypes.ConnectionRequired, (Object)false);
        tx.setSoleAttributeValue((ArtifactId)mimIcdImport, (AttributeTypeToken)CoreAttributeTypes.TransportTypeRequired, (Object)true);
        tx.commit();
        List roles = superUser.getRoles();
        if (!roles.contains(CoreUserGroups.AccountAdmin)) {
            roles.add(CoreUserGroups.AccountAdmin);
        }
        if (!roles.contains(CoreUserGroups.OseeAdmin)) {
            roles.add(CoreUserGroups.OseeAdmin);
        }
        if (!roles.contains(CoreUserGroups.OseeAccessAdmin)) {
            roles.add(CoreUserGroups.OseeAccessAdmin);
        }
        if (!roles.contains(MimUserGroups.MimAdmin)) {
            roles.add(MimUserGroups.MimAdmin);
        }
        if (!roles.contains(CIUserGroups.CIAdmin)) {
            roles.add(CIUserGroups.CIAdmin);
        }
        UserToken userWithRoles = UserToken.create((Long)superUser.getId(), (String)superUser.getName(), (String)superUser.getEmail(), (String)superUser.getUserId(), (boolean)true, (List)superUser.getLoginIds(), (List)roles);
        UserService userService = this.orcsApi.userService();
        userService.clearCaches();
        HashSet<UserToken> users = new HashSet<UserToken>(SystemUser.values());
        users.remove(userWithRoles);
        Set<UserToken> bootsrapUsers = BootstrapUsers.getBoostrapUsers();
        Conditions.assertFalse((boolean)bootsrapUsers.isEmpty(), (String)"Bootstrap Users should NOT be empty.", (Object[])new Object[0]);
        users.addAll(bootsrapUsers);
        if (!users.contains(userWithRoles)) {
            users.add(userWithRoles);
        }
        OseeProperties.setIsInTest((boolean)true);
        userService.setUserForCurrentThread(UserId.valueOf((ArtifactId)userWithRoles));
        TransactionId txId = userService.createUsers(users, "Create System Users");
        OseeProperties.setIsInTest((boolean)false);
        return txId;
    }
}

