/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranchCategoryTokens;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.core.internal.applicability.DemoFeatures;
import org.eclipse.osee.orcs.core.util.Artifacts;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class CreateDemoBranches {
    private final OrcsApi orcsApi;
    private final TransactionFactory txFactory;
    private final OrcsBranch branchOps;

    public CreateDemoBranches(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.txFactory = orcsApi.getTransactionFactory();
        this.branchOps = orcsApi.getBranchOps();
    }

    public void populate() {
        this.createDefaultProgramBranch(DemoBranches.Default_Reqts);
        this.branchOps.createProgramBranch(DemoBranches.SAW_Bld_1, DemoBranches.Default_Reqts);
        this.branchOps.createProgramBranch(DemoBranches.CIS_Bld_1, DemoBranches.Default_Reqts);
        this.branchOps.createBaselineBranch(DemoBranches.SAW_PL, DemoBranches.SAW_Bld_1, ArtifactId.SENTINEL);
        this.branchOps.setBranchCategory((BranchId)DemoBranches.SAW_PL, CoreBranchCategoryTokens.MIM);
        CreateDemoBranches.createProductLineConfig((BranchId)DemoBranches.SAW_PL, this.orcsApi);
        Branch hardeningBranch = this.branchOps.createBaselineBranch(DemoBranches.SAW_PL_Hardening_Branch, DemoBranches.SAW_PL, ArtifactId.SENTINEL);
        this.orcsApi.getAccessControlService().removePermissions((BranchId)hardeningBranch);
        this.branchOps.createWorkingBranch(DemoBranches.SAW_PL_Working_Branch, DemoBranches.SAW_PL, ArtifactId.SENTINEL);
    }

    public static void createProductLineConfig(BranchId branch, OrcsApi orcsApi) {
        TransactionBuilder tx = orcsApi.getTransactionFactory().createTransaction(branch, "Create Product Line folders");
        ArtifactToken plFolder = Artifacts.getOrCreate(CoreArtifactTokens.ProductLineFolder, (ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, tx, orcsApi);
        Artifacts.getOrCreate(CoreArtifactTokens.ProductsFolder, (ArtifactId)plFolder, tx, orcsApi);
        ArtifactToken featuresFolder = Artifacts.getOrCreate(CoreArtifactTokens.FeaturesFolder, (ArtifactId)plFolder, tx, orcsApi);
        Artifacts.getOrCreate(CoreArtifactTokens.PlCfgGroupsFolder, (ArtifactId)plFolder, tx, orcsApi);
        ArtifactToken productA = tx.createView(branch, "Product A");
        ArtifactToken productB = tx.createView(branch, "Product B");
        ArtifactToken productC = tx.createView(branch, "Product C");
        ArtifactToken productD = tx.createView(branch, "Product D");
        tx.setSoleAttributeValue((ArtifactId)productA, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Description for A");
        tx.setSoleAttributeValue((ArtifactId)productB, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Description for B");
        tx.setSoleAttributeValue((ArtifactId)productC, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Description for C");
        tx.setSoleAttributeValue((ArtifactId)productD, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Description for D");
        ArtifactToken[] products = new ArtifactToken[]{productA, productB, productC, productD};
        CreateDemoBranches.createFeatureConfigs((ArtifactId)featuresFolder, tx, orcsApi);
        CreateDemoBranches.configureFeature(tx, DemoFeatures.ROBOT_ARM_LIGHT.name(), (ArtifactId[])products, "Excluded", "Included", "Excluded", "Excluded");
        CreateDemoBranches.configureFeature(tx, DemoFeatures.ENGINE_5.name(), (ArtifactId[])products, "A2543", "A2543", "A2543", "B5543");
        CreateDemoBranches.configureFeature(tx, DemoFeatures.JHU_CONTROLLER.name(), (ArtifactId[])products, "Excluded", "Included", "Included", "Excluded");
        CreateDemoBranches.configureFeature(tx, DemoFeatures.ROBOT_SPEAKER.name(), (ArtifactId[])products, "SPKR_A", "SPKR_A", "SPKR_B", "SPKR_B");
        CreateDemoBranches.createLegacyFeatureConfig((ArtifactId)featuresFolder, tx);
        tx.createBranchCategory(branch, CoreBranchCategoryTokens.PLE);
        tx.createBranchCategory(branch, CoreBranchCategoryTokens.ATS);
        TupleQuery query = orcsApi.getQueryFactory().tupleQuery();
        GammaId gamma = GammaId.SENTINEL;
        gamma = query.getTuple2GammaFromE1E2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((int)0), (Object)"Base");
        if (!gamma.isValid()) {
            tx.addTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((int)0), (Object)"Base");
        } else {
            tx.introduceTuple((TupleTypeId)CoreTupleTypes.ApplicabilityDefinition, gamma);
        }
        tx.commit();
        ConfigurationGroupDefinition group = new ConfigurationGroupDefinition();
        group.setName("abGroup");
        group.setDescription("Description for abGroup");
        orcsApi.getApplicabilityOps().createCfgGroup(group, branch);
        orcsApi.getApplicabilityOps().relateCfgGroupToView("abGroup", "Product A", branch);
        orcsApi.getApplicabilityOps().relateCfgGroupToView("abGroup", "Product B", branch);
        orcsApi.getApplicabilityOps().syncConfigGroup(branch);
    }

    private static void createFeatureConfigs(ArtifactId folder, TransactionBuilder tx, OrcsApi orcsApi) {
        XResultData results = new XResultData();
        List<String> def1Values = Arrays.asList("Included", "Excluded");
        FeatureDefinition def1 = new FeatureDefinition(DemoFeatures.ROBOT_ARM_LIGHT.name(), "String", def1Values, "Included", false, "A significant capability", Arrays.asList("Test"));
        ArtifactToken def1Tok = orcsApi.getApplicabilityOps().createFeatureDefinition(def1, tx, results);
        CreateDemoBranches.configureApplicabilityValues(tx, (ArtifactId)def1Tok, DemoFeatures.ROBOT_ARM_LIGHT.name(), def1Values);
        List<String> def2Values = Arrays.asList("A2543", "B5543");
        FeatureDefinition def2 = new FeatureDefinition(DemoFeatures.ENGINE_5.name(), "String", def2Values, "A2543", false, "Used select type of engine", Arrays.asList("Test"));
        ArtifactToken def2Tok = orcsApi.getApplicabilityOps().createFeatureDefinition(def2, tx, results);
        CreateDemoBranches.configureApplicabilityValues(tx, (ArtifactId)def2Tok, DemoFeatures.ENGINE_5.name(), def2Values);
        List<String> def3Values = Arrays.asList("Included", "Excluded");
        FeatureDefinition def3 = new FeatureDefinition(DemoFeatures.JHU_CONTROLLER.name(), "String", def3Values, "Included", false, "A small point of variation", null);
        ArtifactToken def3Tok = orcsApi.getApplicabilityOps().createFeatureDefinition(def3, tx, results);
        CreateDemoBranches.configureApplicabilityValues(tx, (ArtifactId)def3Tok, DemoFeatures.JHU_CONTROLLER.name(), def3Values);
        List<String> def4Values = Arrays.asList("SPKR_A", "SPKR_B", "SPKR_C");
        FeatureDefinition def4 = new FeatureDefinition(DemoFeatures.ROBOT_SPEAKER.name(), "String", def4Values, "SPKR_A", true, "This feature is multi-select.", null);
        ArtifactToken def4Tok = orcsApi.getApplicabilityOps().createFeatureDefinition(def4, tx, results);
        CreateDemoBranches.configureApplicabilityValues(tx, (ArtifactId)def4Tok, DemoFeatures.ROBOT_SPEAKER.name(), def4Values);
        Conditions.assertFalse((boolean)results.isErrors(), (String)results.toString(), (Object[])new Object[0]);
    }

    private static void createLegacyFeatureConfig(ArtifactId folder, TransactionBuilder tx) {
        ArtifactToken featureDefinition = tx.createArtifact(folder, CoreArtifactTypes.FeatureDefinition, "Feature Definition_SAW_Bld_1");
        String featureDefJson = "[{\"name\": \"" + DemoFeatures.ROBOT_ARM_LIGHT.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"Included\", \"Excluded\"]," + "\"defaultValue\": \"Included\"," + "\"description\": \"Test It\"" + "}, {" + "\"name\": \"" + DemoFeatures.ENGINE_5.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"A2543\", \"B5543\"]," + "\"defaultValue\": \"A2543\"," + "\"description\": \"Test It\"" + "},{" + "\"name\": \"" + DemoFeatures.JHU_CONTROLLER.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"Included\", \"Excluded\"]," + "\"defaultValue\": \"Excluded\"," + "\"description\": \"Test It\"" + "},{" + "\"name\": \"" + DemoFeatures.ROBOT_SPEAKER.name() + "\"," + "\"type\": \"multiple\"," + "\"values\": [\"SPKR_A\", \"SPKR_B\", \"SPKR_C\"]," + "\"defaultValue\": \"SPKR_A\"," + "\"description\": \"Test It\"" + "}" + "]";
        tx.createAttribute((ArtifactId)featureDefinition, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)featureDefJson);
    }

    private static void configureFeature(TransactionBuilder tx, String featureName, ArtifactId[] products, String ... featureValues) {
        int i = 0;
        while (i < products.length) {
            tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)products[i], (Object)(String.valueOf(featureName) + " = " + featureValues[i]));
            ++i;
        }
    }

    private static void configureApplicabilityValues(TransactionBuilder tx, ArtifactId featureId, String featureName, List<String> featureValues) {
        for (String value : featureValues) {
            tx.addTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)featureId, (Object)(String.valueOf(featureName) + " = " + value));
        }
    }

    private void createDefaultProgramBranch(BranchToken branch) {
        this.branchOps.createProgramBranch(branch);
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)branch, "Create Product Decomposition");
        ArtifactToken sawProduct = tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.ProductDecomposition);
        for (String subsystem : DemoSubsystems.getSubsystems()) {
            tx.createArtifact((ArtifactId)sawProduct, CoreArtifactTypes.Component, subsystem);
        }
        tx.commit();
    }
}

