/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds.criteria;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;

public class CriteriaArtifactGuids
extends Criteria {
    private final Collection<String> artifactGuids;

    public CriteriaArtifactGuids(Collection<String> artifactGuids) {
        this.artifactGuids = artifactGuids;
    }

    @Override
    public void checkValid(Options options) {
        Conditions.checkNotNullOrEmpty(this.artifactGuids, (String)"artifact guids");
        ArrayList<String> invalids = new ArrayList<String>();
        for (String guid : this.artifactGuids) {
            if (GUID.isValid((CharSequence)guid)) continue;
            invalids.add(guid);
        }
        Conditions.checkExpressionFailOnTrue((!invalids.isEmpty() ? 1 : 0) != 0, (String)"Invalid Guids - %s", (Object[])new Object[]{invalids});
    }

    public Collection<String> getIds() {
        return this.artifactGuids;
    }

    @Override
    public String toString() {
        return "CriteriaArtifactGuids [artifactGuids=" + this.artifactGuids + "]";
    }
}

