/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class RelationDataSideA {
    private final ArtifactId artA;
    private final RelationTypeToken relType;
    private TreeMap<Integer, Pair<ArtifactId, GammaId>> relOrders;

    public RelationDataSideA(ArtifactId artA, RelationTypeToken relType, TreeMap<Integer, Pair<ArtifactId, GammaId>> relOrders) {
        this.artA = artA;
        this.relType = relType;
        this.setRelOrders(relOrders);
    }

    public ArtifactId getArtA() {
        return this.artA;
    }

    public RelationTypeToken getRelType() {
        return this.relType;
    }

    public void addRelOrder(ArtifactId b_art_id, int relOrder) {
        this.relOrders.put(relOrder, (Pair<ArtifactId, GammaId>)new Pair((Object)b_art_id, (Object)GammaId.SENTINEL));
    }

    public int hashCode() {
        return Objects.hash(this.artA.getIdString(), this.relType.getIdString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationDataSideA other = (RelationDataSideA)obj;
        return Objects.equals(this.artA, other.artA) && Objects.equals(this.relType, other.relType);
    }

    public String toString() {
        return "RelationOrderData [artA=" + this.artA.getIdString() + ", relType=" + this.relType.getIdString() + "]";
    }

    public TreeMap<Integer, Pair<ArtifactId, GammaId>> getRelOrders() {
        return this.relOrders;
    }

    public void setRelOrders(TreeMap<Integer, Pair<ArtifactId, GammaId>> relOrders) {
        this.relOrders = relOrders;
    }
}

