/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTransactionData;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationTransactionData;
import org.eclipse.osee.framework.skynet.core.transaction.AttributeTaggingOperation;
import org.eclipse.osee.framework.skynet.core.transaction.BaseTransactionData;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.AbstractDbTxOperation;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;

public final class StoreSkynetTransactionOperation
extends AbstractDbTxOperation
implements BaseTransactionData.InsertDataCollector {
    private static final String UPDATE_TXS_NOT_CURRENT = "UPDATE osee_txs SET tx_current = " + TxCurrent.NOT_CURRENT + " WHERE branch_id = ? AND transaction_id = ? AND gamma_id = ?";
    private final HashCollection<String, Object[]> dataItemInserts = new HashCollection();
    private final Map<Integer, String> dataInsertOrder = new HashMap<Integer, String>();
    private final BranchId branch;
    private final TransactionRecord transactionRecord;
    private final Collection<BaseTransactionData> txDatas;
    private final Collection<Artifact> artifactReferences;
    private boolean executedWithException;
    private static final boolean useNewEvents = FrameworkEventUtil.USE_NEW_EVENTS;

    public StoreSkynetTransactionOperation(String name, BranchId branch, TransactionRecord transactionRecord, Collection<BaseTransactionData> txDatas, Collection<Artifact> artifactReferences) {
        super(ConnectionHandler.getJdbcClient(), name, "org.eclipse.osee.framework.skynet.core");
        this.branch = branch;
        this.transactionRecord = transactionRecord;
        this.txDatas = txDatas;
        this.artifactReferences = artifactReferences;
    }

    @Override
    public TransactionId getTransaction() {
        return this.transactionRecord;
    }

    @Override
    public BranchId getBranch() {
        return this.branch;
    }

    @Override
    public void internalAddInsertToBatch(int insertPriority, String insertSql, Object ... data) {
        this.dataItemInserts.put((Object)insertSql, (Object)data);
        this.dataInsertOrder.put(insertPriority, insertSql);
    }

    @Override
    protected void doTxWork(IProgressMonitor monitor, JdbcConnection connection) {
        this.executedWithException = false;
        TransactionManager.internalPersist(connection, this.transactionRecord);
        if (!this.txDatas.isEmpty()) {
            this.executeTransactionDataItems(connection);
            if (BranchManager.getState(this.branch).isCreated()) {
                BranchManager.setState(this.branch, BranchState.MODIFIED);
            }
        }
    }

    @Override
    public void handleTxException(IProgressMonitor monitor, Exception ex) {
        this.executedWithException = true;
        for (BaseTransactionData transactionData : this.txDatas) {
            try {
                transactionData.internalOnRollBack();
            }
            catch (OseeCoreException ex1) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex1);
            }
        }
    }

    @Override
    public void handleTxFinally(IProgressMonitor monitor) {
        if (!this.executedWithException) {
            this.updateModifiedCachedObject();
            this.tagGammas();
        }
    }

    private void tagGammas() {
        LinkedHashSet<Long> gammasToTag = new LinkedHashSet<Long>();
        for (BaseTransactionData transactionData : this.txDatas) {
            Attribute<?> attr;
            AttributeTransactionData attrData;
            if (transactionData.getModificationType().isExistingVersionUsed() || !(transactionData instanceof AttributeTransactionData) || (attrData = (AttributeTransactionData)transactionData).getAttribute().isUseBackingData() || !(attr = ((AttributeTransactionData)transactionData).getAttribute()).getAttributeType().isTaggable()) continue;
            gammasToTag.add(transactionData.getGammaId().getId());
        }
        if (!gammasToTag.isEmpty()) {
            AttributeTaggingOperation op = new AttributeTaggingOperation(gammasToTag);
            Operations.executeWorkAndCheckStatus((IOperation)op, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void executeTransactionDataItems(JdbcConnection connection) {
        ArrayList<Object[]> txNotCurrentData = new ArrayList<Object[]>();
        for (BaseTransactionData transactionData : this.txDatas) {
            transactionData.addInsertToBatch(this);
            this.fetchTxNotCurrent(connection, this.branch, transactionData, txNotCurrentData);
        }
        ArrayList<Integer> keys = new ArrayList<Integer>(this.dataInsertOrder.keySet());
        Collections.sort(keys);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int priority = (Integer)iterator.next();
            String sqlKey = this.dataInsertOrder.get(priority);
            this.getJdbcClient().runBatchUpdate(connection, sqlKey, (Iterable)this.dataItemInserts.getValues((Object)sqlKey));
        }
        this.getJdbcClient().runBatchUpdate(connection, UPDATE_TXS_NOT_CURRENT, txNotCurrentData);
    }

    private void fetchTxNotCurrent(JdbcConnection connection, BranchId branchId, BaseTransactionData transactionData, List<Object[]> results) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (JdbcStatement chStmt = this.getJdbcClient().getStatement(connection);){
            String query = ServiceUtil.getSql(transactionData.getSelectTxNotCurrentSql());
            if (transactionData.getSelectTxNotCurrentSql().equals((Object)OseeSql.TX_GET_PREVIOUS_TX_NOT_CURRENT_RELATIONS2)) {
                RelationLink rel = ((RelationTransactionData)transactionData).getRelation();
                chStmt.runPreparedQuery(query, new Object[]{branchId, rel.getArtifactA(), rel.getArtifactB(), rel.getRelationType()});
            } else {
                chStmt.runPreparedQuery(query, new Object[]{transactionData.getItemId(), branchId});
            }
            while (chStmt.next()) {
                results.add(new Object[]{branchId, chStmt.getLong("transaction_id"), chStmt.getLong("gamma_id")});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateModifiedCachedObject() {
        if (useNewEvents) {
            ArtifactTopicEvent artifactTopicEvent = new ArtifactTopicEvent((TransactionToken)this.transactionRecord);
            for (BaseTransactionData transactionData : this.txDatas) {
                transactionData.internalUpdate(this.transactionRecord);
            }
            for (BaseTransactionData transactionData : this.txDatas) {
                transactionData.internalAddToEvents(artifactTopicEvent);
            }
            for (Artifact artifact : this.artifactReferences) {
                if (!artifact.hasDirtyAttributes()) continue;
                artifactTopicEvent.addArtifact(artifact);
            }
            for (BaseTransactionData transactionData : this.txDatas) {
                transactionData.internalClearDirtyState();
            }
            for (Artifact artifact : this.artifactReferences) {
                artifact.getRelationOrderRecords().clear();
            }
            if (!artifactTopicEvent.getArtifacts().isEmpty() || !artifactTopicEvent.getRelations().isEmpty()) {
                OseeEventManager.kickArtifactTopicEvent(this, artifactTopicEvent);
            }
        } else {
            ArtifactEvent artifactEvent = new ArtifactEvent((TransactionToken)this.transactionRecord);
            for (BaseTransactionData transactionData : this.txDatas) {
                transactionData.internalUpdate(this.transactionRecord);
            }
            for (BaseTransactionData transactionData : this.txDatas) {
                transactionData.internalAddToEvents(artifactEvent);
            }
            for (Artifact artifact : this.artifactReferences) {
                if (!artifact.hasDirtyAttributes()) continue;
                artifactEvent.addArtifact(artifact);
            }
            for (BaseTransactionData transactionData : this.txDatas) {
                transactionData.internalClearDirtyState();
            }
            for (Artifact artifact : this.artifactReferences) {
                artifact.getRelationOrderRecords().clear();
            }
            if (!artifactEvent.getArtifacts().isEmpty() || !artifactEvent.getRelations().isEmpty()) {
                OseeEventManager.kickPersistEvent(this, artifactEvent);
            }
        }
    }
}

