/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.revision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.Multiplicity;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.BranchMergeException;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.conflict.ArtifactConflictBuilder;
import org.eclipse.osee.framework.skynet.core.conflict.AttributeConflict;
import org.eclipse.osee.framework.skynet.core.conflict.AttributeConflictBuilder;
import org.eclipse.osee.framework.skynet.core.conflict.Conflict;
import org.eclipse.osee.framework.skynet.core.conflict.ConflictBuilder;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.utility.Id4JoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.IdJoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;

public class ConflictManagerInternal {
    private static final String MULTIPLICITY_DETECTION = "SELECT%s art.art_id, art.art_type_id, dest.attr_id as dest_attr_id, src.attr_id as src_attr_id, src.attr_type_id src_attr_type_id FROM osee_txs txs_src, osee_attribute src, osee_join_id jid, osee_attribute dest, osee_txs txs_dest, osee_txs art_tx, osee_artifact art WHERE txs_src.branch_id = ? AND txs_src.tx_current = 1 AND txs_src.transaction_id > ? AND txs_src.gamma_id = src.gamma_id AND src.attr_type_id = jid.id AND jid.query_id = ? AND src.art_id = art.art_id and art_tx.branch_id = txs_src.branch_id and art_tx.gamma_id = art.gamma_id and art_tx.tx_current = 1 AND src.art_id = dest.art_id AND src.attr_type_id = dest.attr_type_id AND dest.attr_id <> src.attr_id AND dest.gamma_id = txs_dest.gamma_id AND txs_dest.branch_id = ? AND txs_dest.tx_current = 1";
    private static final String CONFLICT_CLEANUP = "DELETE FROM osee_conflict t1 WHERE merge_branch_id = ? AND NOT EXISTS (SELECT 'X' FROM osee_join_id4 WHERE query_id = ? AND t1.conflict_id = id2 AND (t1.conflict_type = id3 or id3 is NULL))";
    private static final String GET_DESTINATION_BRANCHES = "SELECT dest_branch_id FROM osee_merge WHERE source_branch_id = ?";
    private static final String GET_MERGE_DATA = "SELECT commit_transaction_id, merge_branch_id FROM osee_merge WHERE source_branch_id = ? AND dest_branch_id = ? and commit_transaction_id > 0";
    private static final String GET_COMMIT_TRANSACTION_COMMENT = "SELECT transaction_id FROM osee_tx_details WHERE osee_comment = ? AND branch_id = ?";

    public static List<Conflict> getConflictsPerBranch(TransactionToken commitTransaction, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Loading Merge Manager for Transaction %d", commitTransaction.getId()), 100);
        monitor.subTask("Finding Database stored conflicts");
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        JdbcStatement chStmt = ConnectionHandler.getStatement();
        try {
            chStmt.runPreparedQuery(ServiceUtil.getSql(OseeSql.CONFLICT_GET_HISTORICAL_ATTRIBUTES), new Object[]{commitTransaction.getId()});
            while (chStmt.next()) {
                BranchToken sourceBranch = BranchManager.getBranchToken(chStmt.getLong("source_branch_id"));
                if (BranchManager.isArchived((BranchId)sourceBranch)) {
                    sourceBranch = null;
                }
                AttributeConflict attributeConflict = new AttributeConflict(GammaId.valueOf((Long)chStmt.getLong("source_gamma_id")), GammaId.valueOf((Long)chStmt.getLong("dest_gamma_id")), ArtifactId.valueOf((Long)chStmt.getLong("art_id")), null, commitTransaction, chStmt.getString("source_value"), AttributeId.valueOf((Long)chStmt.getLong("attr_id")), ServiceUtil.getOrcsTokenService().getAttributeTypeOrCreate(Long.valueOf(chStmt.getLong("attr_type_id"))), BranchId.valueOf((Long)chStmt.getLong("merge_branch_id")), sourceBranch, BranchManager.getBranchToken(chStmt.getLong("dest_branch_id")));
                attributeConflict.setStatus(ConflictStatus.valueOf((int)chStmt.getInt("status")));
                conflicts.add(attributeConflict);
            }
        }
        finally {
            chStmt.close();
            monitor.done();
        }
        return conflicts;
    }

    public static List<Conflict> getConflictsPerBranch(BranchToken sourceBranch, BranchToken destinationBranch, TransactionToken baselineTransaction, IProgressMonitor monitor) {
        ArrayList<ConflictBuilder> conflictBuilders = new ArrayList<ConflictBuilder>();
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        HashSet<ArtifactId> artIdSet = new HashSet<ArtifactId>();
        HashSet<ArtifactId> artIdSetDontShow = new HashSet<ArtifactId>();
        HashSet<ArtifactId> artIdSetDontAdd = new HashSet<ArtifactId>();
        if (sourceBranch == null || destinationBranch == null) {
            throw new OseeArgumentException("Source Branch = %s Destination Branch = %s", new Object[]{sourceBranch, destinationBranch});
        }
        TransactionToken commitTransactionId = ConflictManagerInternal.getCommitTransaction(sourceBranch, destinationBranch);
        if (commitTransactionId.isValid()) {
            return ConflictManagerInternal.getConflictsPerBranch(commitTransactionId, monitor);
        }
        monitor.beginTask(String.format("Loading Merge Manager for Branch %s into Branch %s", sourceBranch, destinationBranch), 100);
        monitor.subTask("Finding Database stored conflicts");
        TransactionToken commonTransaction = ConflictManagerInternal.findCommonTransaction((BranchId)sourceBranch, (BranchId)destinationBranch);
        Set<AttributeTypeToken> singleMultiplicityTypes = AttributeTypeManager.getSingleMultiplicityTypes();
        ConflictManagerInternal.loadMultiplicityConflicts(singleMultiplicityTypes, (BranchId)sourceBranch, (BranchId)destinationBranch, conflictBuilders, artIdSet);
        Objects.requireNonNull(commonTransaction, "Common Transaction can not be null");
        ConflictManagerInternal.loadArtifactVersionConflicts(ServiceUtil.getSql(OseeSql.CONFLICT_GET_ARTIFACTS_DEST), sourceBranch, destinationBranch, baselineTransaction, conflictBuilders, artIdSet, artIdSetDontShow, artIdSetDontAdd, monitor, commonTransaction);
        ConflictManagerInternal.loadArtifactVersionConflicts(ServiceUtil.getSql(OseeSql.CONFLICT_GET_ARTIFACTS_SRC), sourceBranch, destinationBranch, baselineTransaction, conflictBuilders, artIdSet, artIdSetDontShow, artIdSetDontAdd, monitor, commonTransaction);
        ConflictManagerInternal.loadAttributeConflictsNew(sourceBranch, destinationBranch, baselineTransaction, conflictBuilders, artIdSet, monitor, commonTransaction);
        artIdSet.removeAll(artIdSetDontAdd);
        if (artIdSet.isEmpty()) {
            return conflicts;
        }
        monitor.subTask("Creating and/or maintaining the Merge Branch");
        BranchToken mergeBranch = BranchManager.getOrCreateMergeBranch(sourceBranch, destinationBranch, new ArrayList<ArtifactId>(artIdSet));
        if (mergeBranch == null) {
            throw new BranchMergeException("Could not create the Merge Branch.", new Object[0]);
        }
        monitor.worked(15);
        ConflictManagerInternal.preloadConflictArtifacts(sourceBranch, destinationBranch, mergeBranch, artIdSet, monitor);
        for (ConflictBuilder conflictBuilder : conflictBuilders) {
            Conflict conflict = ConflictManagerInternal.getConflict(conflictBuilder, mergeBranch, artIdSetDontShow);
            if (conflict == null) continue;
            conflicts.add(conflict);
        }
        ConflictManagerInternal.cleanUpConflictDB(conflicts, (BranchId)mergeBranch, monitor);
        return conflicts;
    }

    private static Conflict getConflict(ConflictBuilder conflictBuilder, BranchToken mergeBranch, Set<ArtifactId> artIdSetDontShow) {
        Conflict conflict = conflictBuilder.getConflict((BranchId)mergeBranch, artIdSetDontShow);
        if (conflict != null) {
            conflict.computeStatus();
        }
        return conflict;
    }

    private static Collection<Artifact> preloadConflictArtifacts(BranchToken sourceBranch, BranchToken destBranch, BranchToken mergeBranch, Collection<ArtifactId> artIdSet, IProgressMonitor monitor) {
        monitor.subTask("Preloading Artifacts Associated with the Conflicts");
        List<Artifact> artifacts = ArtifactQuery.getArtifactListFrom(artIdSet, (BranchId)sourceBranch, DeletionFlag.INCLUDE_DELETED);
        artifacts.addAll(ArtifactQuery.getArtifactListFrom(artIdSet, (BranchId)destBranch, DeletionFlag.INCLUDE_DELETED));
        artifacts.addAll(ArtifactQuery.getArtifactListFrom(artIdSet, (BranchId)mergeBranch, DeletionFlag.INCLUDE_DELETED));
        monitor.worked(25);
        return artifacts;
    }

    private static void loadMultiplicityConflicts(Collection<AttributeTypeToken> types, BranchId source, BranchId dest, List<ConflictBuilder> conflictBuilders, Set<ArtifactId> artIdSet) {
        JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();
        LinkedList batchParams = new LinkedList();
        OrcsTokenService tokenService = (OrcsTokenService)OsgiUtil.getService(ConflictManagerInternal.class, OrcsTokenService.class);
        Throwable throwable = null;
        Object var9_10 = null;
        try (IdJoinQuery joinQuery = JoinUtility.createIdJoinQuery();){
            joinQuery.addAndStore(types);
            Consumer<JdbcStatement> consumer = stmt -> {
                ArtifactId artId = ArtifactId.valueOf((Long)stmt.getLong("art_id"));
                Long artTypeId = stmt.getLong("art_type_id");
                Long sAttrId = stmt.getLong("src_attr_id");
                Long sAttrTypeId = stmt.getLong("src_attr_type_id");
                Long dAttrId = stmt.getLong("dest_attr_id");
                ArtifactTypeToken artifactType = tokenService.getArtifactType(artTypeId);
                Multiplicity multiplicity = artifactType.getMultiplicity((AttributeTypeToken)tokenService.getAttributeType(sAttrTypeId));
                if (multiplicity.equals((Object)Multiplicity.ZERO_OR_ONE) || multiplicity.equals((Object)Multiplicity.EXACTLY_ONE)) {
                    artIdSet.add(artId);
                    batchParams.add(new Object[]{dAttrId, sAttrId, artId});
                }
            };
            String sql = jdbcClient.injectOrderedHint(MULTIPLICITY_DETECTION);
            jdbcClient.runQuery(consumer, sql, new Object[]{source, BranchManager.getBaseTransaction(source), joinQuery.getQueryId(), dest});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!batchParams.isEmpty()) {
            String updateSql = "update osee_attribute set attr_id = ? where attr_id = ? and art_id = ?";
            jdbcClient.runBatchUpdate(updateSql, batchParams);
            for (Object[] params : batchParams) {
                ArtifactQuery.reloadArtifactFromId((ArtifactId)params[2], source);
            }
        }
    }

    private static void loadArtifactVersionConflicts(String sql, BranchToken sourceBranch, BranchToken destinationBranch, TransactionToken baselineTransaction, Collection<ConflictBuilder> conflictBuilders, Set<ArtifactId> artIdSet, Set<ArtifactId> artIdSetDontShow, Set<ArtifactId> artIdSetDontAdd, IProgressMonitor monitor, TransactionToken commonTransaction) {
        boolean hadEntries = false;
        monitor.subTask("Finding Artifact Version Conflicts");
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(sql, new Object[]{sourceBranch, BranchManager.getBaseTransaction((BranchId)sourceBranch), destinationBranch, commonTransaction.getBranch(), commonTransaction, commonTransaction});
            ArtifactId artId = ArtifactId.SENTINEL;
            while (chStmt.next()) {
                hadEntries = true;
                ArtifactId nextArtId = ArtifactId.valueOf((Long)chStmt.getLong("art_id"));
                GammaId sourceGamma = GammaId.valueOf((Long)chStmt.getLong("source_gamma"));
                GammaId destGamma = GammaId.valueOf((Long)chStmt.getLong("dest_gamma"));
                ModificationType sourceModType = ModificationType.valueOf((long)chStmt.getInt("source_mod_type"));
                ModificationType destModType = ModificationType.valueOf((long)chStmt.getInt("dest_mod_type"));
                long artTypeId = chStmt.getLong("art_type_id");
                if (!artId.notEqual((Id)nextArtId)) continue;
                artId = nextArtId;
                if (destModType == ModificationType.DELETED && sourceModType == ModificationType.MODIFIED || destModType == ModificationType.MODIFIED && sourceModType == ModificationType.DELETED) {
                    ArtifactConflictBuilder artifactConflictBuilder = new ArtifactConflictBuilder(sourceGamma, destGamma, artId, baselineTransaction, sourceBranch, destinationBranch, sourceModType, destModType, artTypeId);
                    conflictBuilders.add(artifactConflictBuilder);
                    artIdSet.add(artId);
                    continue;
                }
                if (destModType != ModificationType.DELETED || sourceModType != ModificationType.DELETED) continue;
                artIdSetDontShow.add(artId);
                artIdSetDontAdd.add(artId);
            }
        }
        if (hadEntries) {
            monitor.worked(20);
            artIdSetDontShow.addAll(artIdSet);
        }
    }

    private static void loadAttributeConflictsNew(BranchToken sourceBranch, BranchToken destinationBranch, TransactionToken baselineTransaction, Collection<ConflictBuilder> conflictBuilders, Set<ArtifactId> artIdSet, IProgressMonitor monitor, TransactionToken commonTransaction) {
        monitor.subTask("Finding the Attribute Conflicts");
        Throwable throwable = null;
        Object var9_9 = null;
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(ServiceUtil.getSql(OseeSql.CONFLICT_GET_ATTRIBUTES), new Object[]{sourceBranch, BranchManager.getBaseTransaction((BranchId)sourceBranch), destinationBranch, commonTransaction.getBranch(), commonTransaction});
            AttributeId attrId = AttributeId.SENTINEL;
            while (chStmt.next()) {
                String sourceValue;
                AttributeId nextAttrId = AttributeId.valueOf((Long)chStmt.getLong("attr_id"));
                ArtifactId artId = ArtifactId.valueOf((Long)chStmt.getLong("art_id"));
                GammaId sourceGamma = GammaId.valueOf((Long)chStmt.getLong("source_gamma"));
                GammaId destGamma = GammaId.valueOf((Long)chStmt.getLong("dest_gamma"));
                AttributeTypeGeneric<?> attrTypeId = AttributeTypeManager.getAttributeType(chStmt.getLong("attr_type_id"));
                String string = sourceValue = !chStmt.getString("source_value").isEmpty() ? chStmt.getString("source_value") : chStmt.getString("dest_value");
                if (!attrId.notEqual((Id)nextAttrId) || !ConflictManagerInternal.isAttributeConflictValid(destGamma, (BranchId)sourceBranch)) continue;
                attrId = nextAttrId;
                AttributeConflictBuilder attributeConflictBuilder = new AttributeConflictBuilder(sourceGamma, destGamma, artId, baselineTransaction, sourceBranch, destinationBranch, sourceValue, attrId, attrTypeId);
                conflictBuilders.add(attributeConflictBuilder);
                artIdSet.add(artId);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        monitor.worked(30);
    }

    private static boolean isAttributeConflictValid(GammaId destinationGammaId, BranchId sourceBranch) {
        boolean isValidConflict = true;
        TransactionId parentTransactionNumber = TransactionId.valueOf((int)Integer.MAX_VALUE);
        for (BranchId branch : BranchManager.getAncestors(sourceBranch)) {
            if (!BranchManager.isParentSystemRoot(branch)) {
                isValidConflict &= ConflictManagerInternal.isAttributeConflictValidOnBranch(destinationGammaId, branch, parentTransactionNumber);
                TransactionRecord sourceTx = BranchManager.getSourceTransaction(branch);
                if (sourceTx != null) {
                    parentTransactionNumber = sourceTx;
                }
            }
            if (!isValidConflict) break;
        }
        return isValidConflict;
    }

    private static boolean isAttributeConflictValidOnBranch(GammaId destinationGammaId, BranchId branch, TransactionId endTransaction) {
        String sql = "SELECT count(1) FROM osee_txs txs WHERE txs.gamma_id = ? AND txs.branch_id = ? AND txs.transaction_id <= ?";
        return (Integer)ConnectionHandler.getJdbcClient().fetch((Object)0, sql, new Object[]{destinationGammaId, branch, endTransaction}) == 0;
    }

    private static void cleanUpConflictDB(Collection<Conflict> conflicts, BranchId branch, IProgressMonitor monitor) {
        monitor.subTask("Cleaning up old conflict data");
        if (conflicts != null && conflicts.size() != 0 && branch.isValid()) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Id4JoinQuery joinQuery = JoinUtility.createId4JoinQuery();){
                for (Conflict conflict : conflicts) {
                    Objects.requireNonNull(conflict.getConflictType(), "Conflict Type can not be null");
                    joinQuery.add((Id)branch, conflict.getObjectId(), (Id)TransactionId.valueOf((int)conflict.getConflictType().getValue()));
                }
                joinQuery.store();
                ConnectionHandler.runPreparedUpdate(CONFLICT_CLEANUP, branch, joinQuery.getQueryId());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        monitor.worked(10);
    }

    public static Collection<BranchToken> getDestinationBranchesMerged(BranchId sourceBranch) {
        LinkedList<BranchToken> destinationBranches = new LinkedList<BranchToken>();
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(GET_DESTINATION_BRANCHES, new Object[]{sourceBranch});
            while (chStmt.next()) {
                destinationBranches.add(BranchManager.getBranchToken(chStmt.getLong("dest_branch_id")));
            }
        }
        if (destinationBranches.size() > 1) {
            Collections.sort(destinationBranches);
        }
        return destinationBranches;
    }

    private static TransactionToken getCommitTransaction(BranchToken sourceBranch, BranchToken destBranch) {
        TransactionToken transactionId = TransactionToken.SENTINEL;
        Throwable throwable = null;
        Object var4_5 = null;
        try (JdbcStatement stmt = ConnectionHandler.getStatement();){
            stmt.runPreparedQuery(GET_MERGE_DATA, new Object[]{sourceBranch, destBranch});
            if (stmt.next()) {
                transactionId = TransactionToken.valueOf((long)stmt.getLong("commit_transaction_id"), (BranchId)destBranch);
            }
            if (transactionId.isInvalid()) {
                stmt.runPreparedQuery(GET_COMMIT_TRANSACTION_COMMENT, new Object[]{"Commit Branch " + sourceBranch.getName(), destBranch});
                if (stmt.next()) {
                    transactionId = TransactionToken.valueOf((long)stmt.getLong("transaction_id"), (BranchId)destBranch);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return transactionId;
    }

    public static TransactionToken findCommonTransaction(BranchId sourceBranch, BranchId destBranch) {
        Collection<BranchId> sourceBranches = BranchManager.getAncestors(sourceBranch);
        Collection<BranchId> destBranches = BranchManager.getAncestors(destBranch);
        Object commonAncestor = null;
        for (BranchId branch : sourceBranches) {
            if (!destBranches.contains(branch)) continue;
            commonAncestor = branch;
            break;
        }
        if (commonAncestor == null) {
            throw new OseeCoreException("Cannot find a common ancestor for Branch %s and Branch %s", new Object[]{sourceBranch, destBranch});
        }
        TransactionRecord sourceTransaction = null;
        TransactionToken destTransaction = null;
        if (commonAncestor.equals(destBranch)) {
            destTransaction = TransactionManager.getHeadTransaction((BranchId)commonAncestor);
        } else {
            for (BranchId branch : destBranches) {
                if (!BranchManager.isParent(branch, (BranchId)commonAncestor)) continue;
                destTransaction = BranchManager.getBaseTransaction(branch);
                break;
            }
        }
        for (BranchId branch : sourceBranches) {
            if (!BranchManager.isParent(branch, (BranchId)commonAncestor)) continue;
            sourceTransaction = BranchManager.getBaseTransaction(branch);
            break;
        }
        TransactionToken toReturn = null;
        if (sourceTransaction == null && destTransaction != null) {
            toReturn = destTransaction;
        } else if (sourceTransaction != null && destTransaction == null) {
            toReturn = sourceTransaction;
        } else if (sourceTransaction != null && destTransaction != null) {
            toReturn = sourceTransaction.getId() <= destTransaction.getId() ? sourceTransaction : destTransaction;
        }
        return toReturn;
    }
}

