/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation.order;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.DefaultBasicUuidRelationReorder;
import org.eclipse.osee.framework.core.model.event.RelationOrderModType;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.order.IRelationOrderAccessor;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;

public class RelationOrderData {
    private final CompositeKeyHashMap<RelationTypeToken, RelationSide, Pair<RelationSorter, List<String>>> lists = new CompositeKeyHashMap();
    private final IRelationOrderAccessor accessor;
    private final Artifact artifact;

    public RelationOrderData(IRelationOrderAccessor accessor, Artifact artifact) {
        this.accessor = accessor;
        this.artifact = artifact;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void clear() {
        this.lists.clear();
    }

    public void load() {
        this.clear();
        this.accessor.load(this.artifact, this);
    }

    public Collection<Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>>> entrySet() {
        return this.lists.entrySet();
    }

    public Collection<Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>>> getOrderedEntrySet() {
        ArrayList<Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>>> entries = new ArrayList<Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>>>(this.entrySet());
        Collections.sort(entries, new EntryComparator());
        return entries;
    }

    public List<String> getOrderList(RelationTypeToken type, RelationSide side) {
        Pair<RelationSorter, List<String>> currentOrder = this.getTypeSideEntry(type, side);
        return currentOrder != null ? (List)currentOrder.getSecond() : new ArrayList();
    }

    public RelationSorter getCurrentSorterGuid(RelationTypeToken type, RelationSide side) {
        if (type.isNewRelationTable()) {
            return RelationSorter.USER_DEFINED;
        }
        Pair<RelationSorter, List<String>> currentOrder = this.getTypeSideEntry(type, side);
        return currentOrder != null ? (RelationSorter)currentOrder.getFirst() : type.getOrder();
    }

    private Pair<RelationSorter, List<String>> getTypeSideEntry(RelationTypeToken type, RelationSide side) {
        return (Pair)this.lists.get((Object)type, (Object)side);
    }

    public void addOrderList(RelationTypeToken relationType, RelationSide relationSide, RelationSorter sorterId, List<String> guidList) {
        this.lists.put((Object)relationType, (Object)relationSide, (Object)new Pair((Object)sorterId, guidList));
    }

    public void removeOrderList(RelationTypeToken type, RelationSide side) {
        Conditions.checkNotNull((Object)type, (String)"relationType");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        this.lists.removeAndGet((Object)type, (Object)side);
    }

    public boolean hasEntries() {
        return !this.lists.isEmpty();
    }

    public int size() {
        return this.lists.size();
    }

    public void store(RelationTypeToken type, RelationSide side, RelationSorter requestedSorterId, List<Artifact> relativeSequence) {
        this.storeFromGuids(type, side, requestedSorterId, Artifacts.toGuids(relativeSequence));
    }

    public void storeFromGuids(RelationTypeToken type, RelationSide side, RelationSorter requestedSorterId, List<String> relativeSequence) {
        boolean isDifferentSorterId = this.isDifferentSorterId(type, side, requestedSorterId);
        boolean changingRelatives = this.isRelativeOrderChange(type, side, requestedSorterId, relativeSequence);
        if (isDifferentSorterId || changingRelatives) {
            RelationOrderModType relationOrderModType = null;
            if (this.isRevertingToDefaultTypeOrder(type, side, requestedSorterId)) {
                this.removeOrderList(type, side);
                relationOrderModType = RelationOrderModType.Default;
            } else {
                this.addOrderList(type, side, requestedSorterId, relativeSequence);
                relationOrderModType = RelationOrderModType.Absolute;
            }
            DefaultBasicGuidArtifact guidArtifact = this.artifact.getBasicGuidArtifact();
            DefaultBasicUuidRelationReorder reorder = new DefaultBasicUuidRelationReorder(relationOrderModType, (BranchId)this.artifact.getBranch(), type.getId(), guidArtifact);
            this.accessor.store(this.artifact, this, reorder);
        }
    }

    protected boolean isRevertingToDefaultTypeOrder(RelationTypeToken type, RelationSide side, RelationSorter sorterId) {
        return sorterId.equals((Object)type.getOrder()) && this.isDifferentSorterId(type, side, sorterId);
    }

    protected boolean isRelativeOrderChange(RelationTypeToken type, RelationSide side, RelationSorter sorterId, List<String> relativeSequence) {
        return sorterId.equals((Object)RelationSorter.USER_DEFINED) && !relativeSequence.equals(this.getOrderList(type, side));
    }

    protected boolean isDifferentSorterId(RelationTypeToken type, RelationSide side, RelationSorter sorterId) {
        RelationSorter currentSorterGuid = this.getCurrentSorterGuid(type, side);
        return !sorterId.equals((Object)currentSorterGuid);
    }

    public String toString() {
        return String.format("Relation Order Data for artifact:%s", new Object[]{this.artifact});
    }

    public List<Pair<RelationTypeToken, RelationSide>> getAvailableTypeSides() {
        return this.lists.getEnumeratedKeys();
    }

    private static final class EntryComparator
    implements Serializable,
    Comparator<Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>>> {
        private static final long serialVersionUID = 5242452476694174988L;

        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>> o1, Map.Entry<Pair<RelationTypeToken, RelationSide>, Pair<RelationSorter, List<String>>> o2) {
            int result = ((RelationTypeToken)o1.getKey().getFirst()).compareTo((Named)o2.getKey().getFirst());
            if (result == 0) {
                result = ((RelationSide)o1.getKey().getSecond()).compareTo((Enum)((RelationSide)o2.getKey().getSecond()));
            }
            if (result == 0) {
                result = ((RelationSorter)o1.getValue().getFirst()).compareTo((Enum)((RelationSorter)o2.getValue().getFirst()));
            }
            if (result == 0) {
                ArrayList guids1 = new ArrayList((Collection)o1.getValue().getSecond());
                ArrayList guids2 = new ArrayList((Collection)o2.getValue().getSecond());
                result = guids1.size() - guids2.size();
                if (result == 0) {
                    Collections.sort(guids1);
                    Collections.sort(guids2);
                    int index = 0;
                    while (index < guids1.size()) {
                        result = ((String)guids1.get(index)).compareTo((String)guids2.get(index));
                        if (result != 0) break;
                        ++index;
                    }
                }
            }
            return result;
        }
    }
}

