/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation.order;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.model.event.DefaultBasicUuidRelationReorder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.order.IRelationOrderAccessor;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderData;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderParser;

public class ArtifactRelationOrderAccessor
implements IRelationOrderAccessor {
    private final RelationOrderParser parser;

    public ArtifactRelationOrderAccessor(RelationOrderParser parser) {
        this.parser = parser;
    }

    @Override
    public void load(Artifact artifact, RelationOrderData orderData) {
        String value = artifact.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.RelationOrder, Strings.emptyString());
        this.parser.loadFromXml(orderData, value);
    }

    @Override
    public void store(Artifact artifact, RelationOrderData orderData, DefaultBasicUuidRelationReorder relationOrderRecord) {
        artifact.getRelationOrderRecords().add(relationOrderRecord);
        if (orderData.hasEntries() && !artifact.isDeleted()) {
            artifact.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.RelationOrder, this.parser.toXml(orderData));
        } else {
            artifact.deleteSoleAttribute((AttributeTypeId)CoreAttributeTypes.RelationOrder);
        }
    }
}

