/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.linking;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class OseeLinkParser {
    private static final Matcher LEGACY_MATCHER = Pattern.compile("/(.*?)/guid/(.*?)/(.*)").matcher("");
    private static final Matcher LINK_CONTEXT_MATCHER = Pattern.compile("/(.*?)\\?(.*)").matcher("");
    private static final Matcher PARAMETER_MATCHER = Pattern.compile("([^&]*?)=([^&]*)").matcher("");
    private final Map<String, String> parameterMap = new HashMap<String, String>();
    private final Map<String, String> errorParamMap = new HashMap<String, String>();

    public void parse(String link) {
        this.parameterMap.clear();
        this.errorParamMap.clear();
        link = link.replaceAll("&amp;", "&");
        boolean wasHandled = this.parseOldSchoolStyleLinks(link);
        if (!wasHandled) {
            wasHandled = this.parseNewStyleRequests(link);
        }
        if (!wasHandled) {
            this.errorParamMap.put("linkerr", link);
        }
    }

    public String getErrLink() {
        if (this.errorParamMap != null) {
            return this.errorParamMap.get("linkerr");
        }
        return null;
    }

    public BranchId getId() {
        String branchUuidStr;
        BranchId branchUuid = BranchId.SENTINEL;
        if (this.parameterMap != null && Strings.isValid((String)(branchUuidStr = this.parameterMap.get("branchUuid")))) {
            try {
                branchUuid = BranchId.valueOf((String)branchUuidStr);
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return branchUuid;
    }

    public String getGuid() {
        String guid;
        String guidToReturn = null;
        if (this.parameterMap != null && Strings.isValid((String)(guid = this.parameterMap.get("guid")))) {
            if (!GUID.isValid((CharSequence)guid)) {
                try {
                    guid = URLDecoder.decode(guid, "UTF-8");
                    if (GUID.isValid((CharSequence)guid)) {
                        guidToReturn = guid;
                    }
                }
                catch (Exception ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            } else {
                guidToReturn = guid;
            }
        }
        return guidToReturn;
    }

    private boolean parseNewStyleRequests(String link) {
        boolean wasHandled = false;
        String noHostStr = link.replaceFirst("^http:\\/\\/(.*?)\\/", "/");
        Matcher matcher = LINK_CONTEXT_MATCHER;
        matcher.reset(noHostStr);
        if (matcher.matches()) {
            Matcher dataMatcher = PARAMETER_MATCHER;
            dataMatcher.reset(matcher.group(2));
            while (dataMatcher.find()) {
                this.parameterMap.put(dataMatcher.group(1), dataMatcher.group(2));
                wasHandled = true;
            }
        }
        return wasHandled;
    }

    private boolean parseOldSchoolStyleLinks(String link) {
        boolean wasHandled = false;
        Matcher oldMatcher = LEGACY_MATCHER;
        oldMatcher.reset(link);
        if (oldMatcher.find()) {
            wasHandled = true;
            String guid = oldMatcher.group(2);
            if (oldMatcher.groupCount() > 2) {
                String processType = oldMatcher.group(3);
                if (processType.equals("ats")) {
                    this.parameterMap.put("guid", guid);
                } else if (processType.equals("Define") || processType.equals("")) {
                    this.parameterMap.put("guid", guid);
                } else if (GUID.isValid((CharSequence)guid)) {
                    this.parameterMap.put("guid", guid);
                }
            }
        }
        return wasHandled;
    }
}

