/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.linking;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.util.LinkType;
import org.eclipse.osee.framework.jdk.core.util.xml.XmlEncoderDecoder;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactUrlClient;

public class OseeLinkBuilder {
    private String getLinkId(LinkType destLinkType, Artifact artifact, PresentationType presentationType) {
        String toReturn = destLinkType == LinkType.OSEE_SERVER_LINK ? XmlEncoderDecoder.textToXml((CharSequence)new ArtifactUrlClient().getOpenInOseeLink(artifact, presentationType).toString()).toString() : artifact.getIdString();
        return toReturn;
    }

    private String getLinkText(LinkType linkType, Artifact artifact) {
        StringBuilder builder = new StringBuilder();
        if (linkType.isParagraphRequired()) {
            builder.append(artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, "Undefined"));
        }
        if (linkType.isArtifactNameRequired()) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(artifact.getName());
        }
        if (artifact.isDeleted()) {
            builder.append(" (DELETED)");
        }
        return XmlEncoderDecoder.textToXml((CharSequence)builder).toString();
    }

    public String getWordMlLink(LinkType destLinkType, Artifact artifact) {
        return this.getWordMlLink(destLinkType, artifact, PresentationType.DEFAULT_OPEN);
    }

    public String getWordMlLink(LinkType destLinkType, Artifact artifact, PresentationType presentationType) {
        String linkId = this.getLinkId(destLinkType, artifact, presentationType);
        String linkText = this.getLinkText(destLinkType, artifact);
        return WordCoreUtil.getLink((LinkType)destLinkType, (CharSequence)linkId, (CharSequence)linkText).toString();
    }
}

