/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IBranchEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerLocal;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;

public class BranchEventHandler
implements EventHandlerLocal<IBranchEventListener, BranchEvent> {
    @Override
    public void handle(IBranchEventListener listener, Sender sender, BranchEvent event) {
        List<? extends IEventFilter> filters = listener.getEventFilters();
        if (filters != null) {
            for (IEventFilter iEventFilter : filters) {
                if (iEventFilter.isMatch(event.getSourceBranch()) || iEventFilter.isMatch(event.getDestinationBranch())) continue;
                return;
            }
        }
        if (event.getEventType() == BranchEventType.Added) {
            try {
                BranchManager.checkAndReload(event.getSourceBranch());
            }
            catch (OseeCoreException oseeCoreException) {
                EventUtil.eventLog((String)"IEM: updateBranches", (Throwable)oseeCoreException);
            }
        }
        listener.handleBranchEvent(sender, event);
    }

    @Override
    public void send(Transport transport, Sender sender, BranchEvent event) {
        if (transport.isDispatchToLocalAllowed(sender)) {
            transport.sendLocal(sender, event);
        }
        BranchEventType branchEventType = event.getEventType();
        if (sender.isLocal() && branchEventType.isRemoteEventType()) {
            transport.sendRemote((RemoteEvent)FrameworkEventUtil.getRemoteBranchEvent(event));
        }
    }
}

