/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.parsers;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.importing.parsers.AbstractArtifactExtractor;

public class MarkdownOutlineExtractor
extends AbstractArtifactExtractor {
    private static final String HEADER_REGEX = "^(\\d+(?:\\.\\d+)*|\\d+\\.)\\s+(.*)$";
    private static final String NEWLINE_STRING = "\n";
    private final ArtifactTypeToken contentArtifactTypeToken;
    private final ArtifactTypeToken headingArtifactTypeToken;

    public MarkdownOutlineExtractor(ArtifactTypeToken headingArtifactTypeToken, ArtifactTypeToken contentArtifactTypeToken) {
        this.headingArtifactTypeToken = headingArtifactTypeToken;
        this.contentArtifactTypeToken = contentArtifactTypeToken;
    }

    @Override
    public String getName() {
        return "Markdown Outline Extractor";
    }

    @Override
    public String getDescription() {
        return "Extract data from a Markdown file with an outline, making an artifact for each outline numbered section.";
    }

    @Override
    public boolean isDelegateRequired() {
        return false;
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".md");
            }
        };
    }

    @Override
    protected void extractFromSource(OperationLogger logger, URI source, RoughArtifactCollector collector) throws Exception {
        try (BufferedReader reader = null;){
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(source.toURL().openStream()));
                StringBuilder contentBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    contentBuilder.append(line).append(NEWLINE_STRING);
                }
                String markdown = contentBuilder.toString();
                MutableDataSet options = new MutableDataSet();
                options.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create()));
                Parser parser = Parser.builder((DataHolder)options).build();
                Document document = parser.parse(markdown);
                String lastHeadingNumber = "0";
                int childCount = 0;
                for (Node child : document.getChildren()) {
                    if (child instanceof Heading) {
                        Heading heading = (Heading)child;
                        Pair<RoughArtifact, String> pair = this.setupHeadingRoughArtifact(heading);
                        RoughArtifact headingRoughArtifact = (RoughArtifact)pair.getFirst();
                        lastHeadingNumber = (String)pair.getSecond();
                        childCount = 0;
                        collector.addRoughArtifact(headingRoughArtifact);
                        continue;
                    }
                    if (child instanceof Heading) continue;
                    RoughArtifact contentRoughArtifact = this.setupContentRoughArtifact(child, lastHeadingNumber, ++childCount);
                    collector.addRoughArtifact(contentRoughArtifact);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private RoughArtifact setupContentRoughArtifact(Node child, String headingNumber, int childCount) {
        RoughArtifact roughArtifact = new RoughArtifact(this.contentArtifactTypeToken);
        String content = String.valueOf(child.getChars().toString()) + NEWLINE_STRING;
        int contentLength = content.length();
        int nameLength = Math.min(contentLength, 32);
        String name = content.substring(0, nameLength);
        String sectionNumber = String.valueOf(headingNumber) + "-" + Integer.toString(childCount);
        roughArtifact.setName(name);
        roughArtifact.setSectionNumber(sectionNumber);
        roughArtifact.setAttribute(CoreAttributeTypes.MarkdownContent.getName(), content);
        return roughArtifact;
    }

    private Pair<RoughArtifact, String> setupHeadingRoughArtifact(Heading heading) {
        RoughArtifact roughArtifact = new RoughArtifact(this.headingArtifactTypeToken);
        String headingText = heading.getText().toString();
        Pattern pattern = Pattern.compile(HEADER_REGEX);
        Matcher matcher = pattern.matcher(headingText);
        if (matcher.matches()) {
            String headerNum = matcher.group(1).trim();
            String headerName = matcher.group(2).trim();
            roughArtifact.setSectionNumber(headerNum);
            roughArtifact.setAttribute(CoreAttributeTypes.ParagraphNumber.getName(), headerNum);
            roughArtifact.setName(headerName);
            return Pair.createNonNullImmutable((Object)roughArtifact, (Object)headerNum);
        }
        return Pair.createNonNullImmutable((Object)roughArtifact, (Object)"0");
    }
}

