/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.httpRequests;

import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;

public final class PurgeBranchHttpRequestOperation
extends AbstractOperation {
    private final Branch branch;
    private final boolean recursive;

    public PurgeBranchHttpRequestOperation(BranchId branch, boolean recursive) {
        super("Purge " + branch, "org.eclipse.osee.framework.skynet.core");
        this.branch = BranchManager.getBranch(branch);
        this.recursive = recursive;
    }

    protected void doWork(IProgressMonitor monitor) {
        BranchState currentState = BranchManager.getState((BranchId)this.branch);
        boolean archived = BranchManager.isArchived((BranchId)this.branch);
        ArtifactCache.deCache((BranchId)this.branch);
        this.branch.setBranchState(BranchState.PURGE_IN_PROGRESS);
        this.branch.setArchived(true);
        OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), new BranchEvent(BranchEventType.Purging, (BranchId)this.branch));
        OseeClient client = ServiceUtil.getOseeClient();
        BranchEndpoint proxy = client.getBranchEndpoint();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Response response = proxy.purgeBranch((BranchId)this.branch, this.recursive);){
                if (Response.Status.OK.getStatusCode() == response.getStatus()) {
                    this.branch.setBranchState(BranchState.PURGED);
                    this.branch.setArchived(true);
                    BranchManager.decache(this.branch);
                    OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), new BranchEvent(BranchEventType.Purged, (BranchId)this.branch));
                } else {
                    this.branch.setBranchState(currentState);
                    this.branch.setArchived(archived);
                    OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), new BranchEvent(BranchEventType.StateUpdated, (BranchId)this.branch));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException ex) {
            try {
                this.branch.setBranchState(currentState);
                this.branch.setArchived(archived);
                OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), new BranchEvent(BranchEventType.StateUpdated, (BranchId)this.branch));
            }
            catch (Exception ex2) {
                this.log(ex2);
            }
            throw ex;
        }
    }
}

