/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.httpRequests;

import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.eclipse.osee.define.rest.api.publisher.publishing.PublishingEndpoint;
import org.eclipse.osee.define.rest.api.publisher.publishing.PublishingRequestData;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordUpdateChange;
import org.eclipse.osee.define.rest.api.publisher.publishing.WordUpdateData;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyGroups;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.TemplateManagerEndpoint;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.core.publishing.WordTemplateContentData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;

public class PublishingRequestHandler {
    private static PublishingRequestHandler instance = new PublishingRequestHandler();
    private final TemplateManagerEndpoint templateManagerEndpoint;
    private final PublishingEndpoint publishingEndpoint = ServiceUtil.getOseeClient().getPublishingEndpoint();

    private PublishingRequestHandler() {
        this.templateManagerEndpoint = ServiceUtil.getOseeClient().getTemplateManagerEndpoint();
    }

    public static void deletePublishingTemplateCache() {
        try {
            PublishingRequestHandler.instance.templateManagerEndpoint.deleteCache();
        }
        catch (Exception e) {
            throw new OseeWebApplicationException((Throwable)e, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, new Message().title((CharSequence)"PublishingRequestHandler::deletePublishingTemplateCache, server error.").indentInc().reasonFollows((Throwable)e).toString(), new Object[0]);
        }
    }

    public static PublishingTemplate getPublishingTemplate(PublishingTemplateRequest publishingTemplateRequest) {
        try {
            PublishingTemplate publishingTemplate = PublishingRequestHandler.instance.templateManagerEndpoint.getPublishingTemplate(publishingTemplateRequest);
            return publishingTemplate;
        }
        catch (Exception e) {
            throw new OseeWebApplicationException((Throwable)e, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, new Message().title((CharSequence)"PublishingRequestHandler::getPublishingTemplate, server error.").indentInc().segment((CharSequence)"Publishing Template Request", (Object)publishingTemplateRequest).reasonFollows((Throwable)e).toString(), new Object[0]);
        }
    }

    public static PublishingTemplateKeyGroups getPublishingTemplateKeyGroups() {
        try {
            return PublishingRequestHandler.instance.templateManagerEndpoint.getPublishingTemplateKeyGroups("");
        }
        catch (Exception e) {
            throw new OseeWebApplicationException((Throwable)e, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, new Message().title((CharSequence)"PublishingRequestHandler::getPublishingTemplateKeyGroups, server error.").indentInc().reasonFollows((Throwable)e).toString(), new Object[0]);
        }
    }

    public static Attachment msWordPreview(PublishingRequestData msWordPreviewRequestData) {
        try {
            return PublishingRequestHandler.instance.publishingEndpoint.msWordPreview(msWordPreviewRequestData);
        }
        catch (Exception e) {
            throw new OseeWebApplicationException((Throwable)e, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Exception in \"msWordPreview\" request.", new Object[0]);
        }
    }

    public static Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData data) {
        try {
            return PublishingRequestHandler.instance.publishingEndpoint.renderWordTemplateContent(data);
        }
        catch (Exception e) {
            throw new OseeWebApplicationException((Throwable)e, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Exception in \"renderWordTemplateContent\" request.", new Object[0]);
        }
    }

    public static WordUpdateChange updateWordArtifacts(WordUpdateData wordUpdateData) {
        try {
            return PublishingRequestHandler.instance.publishingEndpoint.updateWordArtifacts(wordUpdateData);
        }
        catch (Exception e) {
            throw new OseeWebApplicationException((Throwable)e, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Exception in \"updateWordArtifacts\" request.", new Object[0]);
        }
    }

    public static String convertMarkdownToHtml(String markdownContent) {
        try {
            return (String)PublishingRequestHandler.instance.publishingEndpoint.convertMarkdownToHtml(markdownContent).readEntity(String.class);
        }
        catch (Exception e) {
            throw new OseeWebApplicationException((Throwable)e, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Exception in \"convertMarkdownToHtml\" request.", new Object[0]);
        }
    }
}

