/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute.providers;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import org.eclipse.core.resources.IFile;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.attribute.providers.AbstractAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.providers.ICharacterAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.utils.BinaryContentUtils;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.ResourcesEndpoint;

public class MappedAttributeDataProvider
extends AbstractAttributeDataProvider
implements ICharacterAttributeDataProvider {
    private String localUri = null;
    private String remoteUri = null;
    private IFile backingFile = null;

    public MappedAttributeDataProvider(Attribute<?> attribute) {
        super(attribute);
    }

    @Override
    public Object[] getData() {
        return new Object[]{"", this.remoteUri};
    }

    @Override
    public String getDisplayableString() {
        return this.isFromLocalWorkspace() ? this.localUri : "Remote Content";
    }

    @Override
    public void loadData(Object ... objects) {
        if (objects != null && objects.length > 1) {
            this.remoteUri = (String)objects[1];
        }
    }

    private ResourcesEndpoint getResourcesEndpoint() {
        OseeClient client = ServiceUtil.getOseeClient();
        return client.getResourcesEndpoint();
    }

    private String getOutfileName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAttribute().getArtifact().getName());
        builder.append(".");
        String extension = null;
        if (!Strings.isValid(extension)) {
            extension = this.getAttribute().getAttributeType().getFileExtension();
        }
        builder.append(extension);
        return builder.toString();
    }

    @Override
    public void persist(GammaId storageId) {
        block14: {
            try {
                if (!this.isFromLocalWorkspace()) break block14;
                InputStream inputStream = null;
                try {
                    ResourcesEndpoint endpoint = this.getResourcesEndpoint();
                    URI sourceUri = new URI(this.localUri);
                    inputStream = sourceUri.toURL().openStream();
                    byte[] compressed = Zip.compressStream((InputStream)inputStream, (String)this.getOutfileName());
                    String resourceId = storageId.getIdString();
                    boolean overwriteAllowed = false;
                    boolean compressOnSave = false;
                    String resourceName = String.format("%s.zip", this.getAttribute().getArtifact().getGuid());
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (Response response = endpoint.saveResource((InputStream)new ByteArrayInputStream(compressed), "attr", resourceId, resourceName, overwriteAllowed, compressOnSave);){
                        String location = BinaryContentUtils.getAttributeLocation(response);
                        if (location != null) {
                            this.remoteUri = location;
                            this.localUri = null;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    Lib.close(inputStream);
                    throw throwable;
                }
                Lib.close((AutoCloseable)inputStream);
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }

    @Override
    public void purge() {
        block13: {
            try {
                if (!this.isRemoteUriValid()) break block13;
                String path = BinaryContentUtils.asResourcePath(this.remoteUri);
                ResourcesEndpoint endpoint = this.getResourcesEndpoint();
                Throwable throwable = null;
                Object var4_6 = null;
                try (Response response = endpoint.deleteResource(path);){
                    if (Response.Status.OK.getStatusCode() == response.getStatus()) {
                        this.remoteUri = null;
                        if (this.isBackingFileValid()) {
                            this.backingFile.delete(true, null);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }

    @Override
    public void setDisplayableString(String toDisplay) {
    }

    @Override
    public String getValueAsString() {
        if (this.isRemoteUriValid() && !this.isBackingFileValid()) {
            try {
                this.backingFile = this.requestRemoteFile();
                this.localUri = null;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        String toReturn = this.localUri;
        if (this.isBackingFileValid()) {
            toReturn = this.backingFile.getLocationURI().toASCIIString();
        }
        return toReturn;
    }

    private boolean isBackingFileValid() {
        return this.backingFile != null && this.backingFile.isAccessible();
    }

    public boolean setValue(Object value) {
        return false;
    }

    private IFile requestRemoteFile() {
        IFile file = null;
        String path = BinaryContentUtils.asResourcePath(this.remoteUri);
        ResourcesEndpoint endpoint = this.getResourcesEndpoint();
        BufferedInputStream inputStream = null;
        try {
            try {
                Response resource = endpoint.getResource(path, false, false);
                InputStream entity = (InputStream)resource.readEntity(InputStream.class);
                inputStream = new BufferedInputStream(entity);
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                ZipEntry entry = zipInputStream.getNextEntry();
                file = OseeData.getIFile((String)entry.getName(), (InputStream)zipInputStream, (boolean)true);
            }
            catch (Exception ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Lib.close(inputStream);
            throw throwable;
        }
        Lib.close((AutoCloseable)inputStream);
        return file;
    }

    public void setLocalUri(String localUri) {
        this.localUri = localUri;
    }

    private boolean isRemoteUriValid() {
        return this.remoteUri != null && this.remoteUri.length() > 0;
    }

    private boolean isFromLocalWorkspace() {
        boolean toReturn = !this.isRemoteUriValid();
        return toReturn;
    }

    @Override
    public Object getValue() {
        return this.getValueAsString();
    }
}

