/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute.providers;

import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.MapEntryAttributeUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.framework.skynet.core.attribute.MapEntryAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.providers.AbstractAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.providers.DataStore;
import org.eclipse.osee.framework.skynet.core.attribute.providers.ICharacterAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.utils.AttributeResourceProcessor;
import org.eclipse.osee.framework.skynet.core.attribute.utils.BinaryContentUtils;

public class MapEntryAttributeDataProvider
extends AbstractAttributeDataProvider<Map.Entry<String, String>>
implements ICharacterAttributeDataProvider<Map.Entry<String, String>>,
ToMessage {
    private static final Object[] EMPTY_VALUE_AND_URI_ARRAY = new Object[]{"", ""};
    private static final String ENCODED_EXTENSION = "zip";
    private static final String ENCODED_MEDIA_TYPE = "application/zip";
    private static final String ENCODED_CHARSET_NAME = "";
    private final DataStore dataStore;
    private final MapEntryAttributeUtil.LocalData localData = new MapEntryAttributeUtil.LocalData();

    public MapEntryAttributeDataProvider(MapEntryAttribute attribute) {
        super(attribute);
        this.dataStore = new DataStore(new AttributeResourceProcessor(attribute));
    }

    @Override
    public Object[] getData() {
        if (this.dataStore.isDataValid()) {
            return new Object[]{ENCODED_CHARSET_NAME, this.dataStore.getLocator()};
        }
        if (this.localData.isDataValid()) {
            return new Object[]{this.localData.getStorageString(), ENCODED_CHARSET_NAME};
        }
        return new Object[]{ENCODED_CHARSET_NAME, ENCODED_CHARSET_NAME};
    }

    @Override
    public String getDisplayableString() {
        this.updateFromDataStore();
        return this.localData.getStorageString();
    }

    @Override
    public Object getValue() {
        this.updateFromDataStore();
        return this.localData.getMapEntry();
    }

    @Override
    public String getValueAsString() {
        this.updateFromDataStore();
        return this.localData.getStorageString();
    }

    @Override
    public void loadData(Object ... objects) {
        if (Objects.isNull(objects) || objects.length == 0) {
            return;
        }
        Object value = objects[0];
        Object uri = objects.length > 1 ? objects[1] : null;
        int state = (Strings.isValidAndNonBlank((Object)value) ? 1 : 0) + (MapEntryAttributeUtil.isValidMapEntry((Object)value) ? 2 : 0) + (Strings.isValidAndNonBlank((Object)uri) ? 4 : 0);
        switch (state) {
            case 0: {
                return;
            }
            case 1: {
                String valueString = (String)value;
                this.localData.set(valueString);
                this.dataStore.clear();
                return;
            }
            case 2: {
                Map.Entry valueMapEntry = (Map.Entry)value;
                this.localData.set(valueMapEntry);
                this.dataStore.clear();
                return;
            }
            case 4: {
                this.localData.clear();
                this.dataStore.clear();
                this.dataStore.setLocator((String)uri);
                return;
            }
            case 3: {
                assert (false) : new Message().title((CharSequence)"MapEntryAttributeDataProvider::loadData, both value and uri are unexpected.").indentInc().segment((CharSequence)"Value", value).segment((CharSequence)"URI", uri).toString();
                return;
            }
        }
        throw Conditions.invalidCase((Object)state, (String)"state", string -> new OseeCoreException(string, new Object[0]));
    }

    @Override
    public void persist(GammaId storageId) {
        this.dataStore.persist(storageId);
    }

    @Override
    public void purge() {
        this.dataStore.purge();
        if (!this.dataStore.isDataValid()) {
            this.localData.clear();
        }
    }

    @Override
    public void setDisplayableString(String toDisplay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setValue(Map.Entry<String, String> mapEntry) {
        if (!MapEntryAttributeUtil.isValidMapEntry(mapEntry)) {
            this.localData.clear();
            this.dataStore.clear();
            return false;
        }
        this.updateFromDataStore();
        if (this.localData.isEqual(mapEntry)) {
            return false;
        }
        this.localData.set(mapEntry);
        this.dataStore.clear();
        if (this.localData.size() > 4000) {
            byte[] compressedBytes;
            String locator = BinaryContentUtils.generateFileName(this.getAttribute());
            try {
                compressedBytes = Zip.compressBytes((byte[])this.localData.getStorageBytes(), (String)locator);
            }
            catch (Exception exception) {
                this.localData.clear();
                this.dataStore.clear();
                return false;
            }
            this.dataStore.clear();
            this.dataStore.setContent(compressedBytes, ENCODED_EXTENSION, ENCODED_MEDIA_TYPE, ENCODED_CHARSET_NAME);
        }
        return true;
    }

    private void updateFromDataStore() {
        if (this.localData.isDataValid()) {
            return;
        }
        byte[] compressedContent = this.dataStore.getContent();
        boolean status = this.localData.setFromCompressed(compressedContent);
        if (!status) {
            this.dataStore.clear();
        }
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"MapEntryAttributeDataProvider").indentInc();
        if (this.localData.isDataValid()) {
            outMessage.title((CharSequence)"Local data is valid.");
        }
        if (this.dataStore.isLocatorValid()) {
            outMessage.title((CharSequence)"DataStore locator is valid.").indentInc().segment((CharSequence)"locator", (Object)this.dataStore.getLocator()).indentDec();
        }
        if (this.dataStore.isDataValid()) {
            outMessage.title((CharSequence)"DataStore data is valid.");
        }
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

